/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;
import org.ladysnake.cca.api.v3.entity.RespawnableComponent;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.entity.StaticEntityComponentPlugin;

public final class CardinalEntityInternals {
    public static final RespawnCopyStrategy<Component> DEFAULT_COPY_STRATEGY = CardinalEntityInternals::defaultCopyStrategy;
    private static final Map<Class<? extends Entity>, ComponentContainer.Factory<Entity>> entityContainerFactories = new HashMap<Class<? extends Entity>, ComponentContainer.Factory<Entity>>();
    private static final Map<ComponentKey<?>, Map<Class<? extends Entity>, RespawnCopyStrategy<?>>> respawnCopyStrategies = new HashMap();
    private static final Object factoryMutex = new Object();

    private CardinalEntityInternals() {
        throw new AssertionError();
    }

    public static ComponentContainer createEntityComponentContainer(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return Objects.requireNonNullElseGet(entityContainerFactories.get(entityClass), () -> CardinalEntityInternals.getEntityFactory(entityClass)).createContainer((Object)entity);
    }

    private static synchronized ComponentContainer.Factory<Entity> getEntityFactory(Class<? extends Entity> entityClass) {
        ComponentContainer.Factory<Entity> factory;
        ComponentContainer.Factory<Entity> existing = entityContainerFactories.get(entityClass);
        if (existing != null) {
            return existing;
        }
        if (StaticEntityComponentPlugin.INSTANCE.requiresStaticFactory(entityClass)) {
            factory = StaticEntityComponentPlugin.INSTANCE.buildDedicatedFactory(entityClass);
        } else {
            Class<? extends Entity> superclass = entityClass.getSuperclass();
            assert (Entity.class.isAssignableFrom(superclass)) : "requiresStaticFactory returned false on Entity?";
            factory = CardinalEntityInternals.getEntityFactory(superclass);
        }
        entityContainerFactories.put(entityClass, factory);
        return factory;
    }

    public static <C extends Component> void registerRespawnCopyStrat(ComponentKey<? super C> type, Class<? extends Entity> entityClass, RespawnCopyStrategy<? super C> strategy) {
        if (respawnCopyStrategies.computeIfAbsent(type, t -> new HashMap()).put(entityClass, strategy) != null) {
            ComponentsInternals.LOGGER.warn("Multiple respawn copy strategies registered for key {} and entity class {}", type, entityClass);
        }
    }

    public static <C extends Component> RespawnCopyStrategy<? super C> getRespawnCopyStrategy(ComponentKey<C> type, Class<? extends LivingEntity> entityClass) {
        @Nullable RespawnCopyStrategy strat = null;
        Class<? extends LivingEntity> c = entityClass;
        while (strat == null && LivingEntity.class.isAssignableFrom(c)) {
            strat = (RespawnCopyStrategy)respawnCopyStrategies.getOrDefault(type, Map.of()).get(c);
            c = c.getSuperclass();
        }
        return strat == null ? DEFAULT_COPY_STRATEGY : strat;
    }

    private static void defaultCopyStrategy(Component from, Component to, HolderLookup.Provider registryLookup, boolean lossless, boolean keepInventory, boolean sameCharacter) {
        if (to instanceof RespawnableComponent) {
            CardinalEntityInternals.playerComponentCopy(from, (RespawnableComponent)to, registryLookup, lossless, keepInventory, sameCharacter);
        } else {
            RespawnCopyStrategy.LOSSLESS_ONLY.copyForRespawn(from, to, registryLookup, lossless, keepInventory, sameCharacter);
        }
    }

    private static <C extends Component> void playerComponentCopy(Component from, RespawnableComponent<C> to, HolderLookup.Provider registryLookup, boolean lossless, boolean keepInventory, boolean sameCharacter) {
        if (to.shouldCopyForRespawn(lossless, keepInventory, sameCharacter)) {
            to.copyForRespawn(from, registryLookup, lossless, keepInventory, sameCharacter);
        }
    }

    public static <C extends Component> void copyAsCopyable(Component from, CopyableComponent<C> to, HolderLookup.Provider registryLookup) {
        to.copyFrom(from, registryLookup);
    }
}

