/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.mixin.entity.common;

import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.entity.CardinalComponentsEntity;
import org.ladysnake.cca.internal.entity.CardinalEntityInternals;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements ComponentProvider {
    @Unique
    private ComponentContainer components;
    @Shadow
    private Level level;

    @Shadow
    public abstract int getId();

    @Shadow
    public abstract RegistryAccess registryAccess();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void initDataTracker(CallbackInfo ci) {
        this.components = CardinalEntityInternals.createEntityComponentContainer((Entity)this);
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    private void toTag(CompoundTag inputTag, CallbackInfoReturnable<CompoundTag> cir) {
        this.components.toTag((CompoundTag)cir.getReturnValue(), (HolderLookup.Provider)this.registryAccess());
    }

    @Inject(method={"readNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V", shift=At.Shift.AFTER)})
    private void fromTag(CompoundTag tag, CallbackInfo ci) {
        this.components.fromTag(tag, (HolderLookup.Provider)this.registryAccess());
    }

    @Nonnull
    public ComponentContainer getComponentContainer() {
        return this.components;
    }

    public Iterable<ServerPlayer> getRecipientsForComponentSync() {
        Entity holder = (Entity)this;
        if (!this.level.isClientSide) {
            ArrayDeque<ServerPlayer> watchers = new ArrayDeque<ServerPlayer>(PlayerLookup.tracking((Entity)holder));
            if (holder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)holder;
                if (player.connection != null) {
                    watchers.addFirst(player);
                }
            }
            return watchers;
        }
        return List.of();
    }

    public <C extends AutoSyncedComponent> ComponentUpdatePayload<?> toComponentPacket(ComponentKey<? super C> key, boolean required, RegistryFriendlyByteBuf data) {
        return new ComponentUpdatePayload(CardinalComponentsEntity.PACKET_ID, (Object)this.getId(), required, key.getId(), data);
    }
}

