/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.categories.MusicIdentifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Music
implements Comparable<Music> {
    public static final String ALL_MUSICS = "all";
    public static final String ALL_MUSIC_DISCS = "disc";
    public static final String DEFAULT_MUSICS = "default";
    public static final ResourceLocation EMPTY_MUSIC_ID = SoundManager.EMPTY_SOUND.getLocation();
    public static final String EMPTY_MUSIC = EMPTY_MUSIC_ID.toString();
    public static final HashMap<String, HashSet<Music>> MUSIC_BY_NAMESPACE = new HashMap();
    public static final HashSet<ResourceLocation> EVENTS = new HashSet();
    public static final HashSet<ResourceLocation> BLACK_LISTED_EVENTS = new HashSet<ResourceLocation>(List.of(ResourceLocation.withDefaultNamespace((String)"music.overworld.old_growth_taiga")));
    public static final HashMap<ResourceLocation, HashSet<Music>> MUSIC_BY_EVENT = new HashMap();
    public static final HashMap<ResourceLocation, HashSet<ResourceLocation>> EVENTS_OF_EVENT = new HashMap();
    public static final Comparator<ResourceLocation> TRANSLATED_ORDER = (a, b) -> String.CASE_INSENSITIVE_ORDER.compare(Music.getTranslatedText(a).getString(), Music.getTranslatedText(b).getString());
    private static final HashMap<ResourceLocation, Component> TRANSLATION_CACHE = new HashMap();
    private static Language LAST_LANG_INSTANCE = Language.getInstance();
    private final ResourceLocation identifier;
    private final HashSet<ResourceLocation> events;

    public Music(ResourceLocation identifier) {
        this.identifier = identifier;
        this.events = new HashSet();
    }

    public static Music getMusicFromIdentifier(ResourceLocation identifier) {
        Optional<Music> music = MUSIC_BY_NAMESPACE.get(ALL_MUSICS).stream().filter(music1 -> music1.getIdentifier().equals((Object)identifier)).findAny();
        return music.orElse(null);
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public HashSet<ResourceLocation> getEvents() {
        return this.events;
    }

    public void addEvent(ResourceLocation event) {
        if (MUSIC_BY_EVENT.containsKey(event)) {
            MUSIC_BY_EVENT.get(event).add(this);
            this.events.add(event);
        }
    }

    public void removeEvent(ResourceLocation event) {
        if (MUSIC_BY_EVENT.containsKey(event)) {
            MUSIC_BY_EVENT.get(event).remove(this);
            this.events.remove(event);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Music && this.identifier.equals((Object)((Music)obj).identifier);
    }

    @Override
    public int compareTo(@NotNull Music music) {
        return this.identifier.compareTo(music.identifier);
    }

    public static Component getTranslatedText(ResourceLocation identifier) {
        if (LAST_LANG_INSTANCE != Language.getInstance()) {
            TRANSLATION_CACHE.clear();
            LAST_LANG_INSTANCE = Language.getInstance();
        }
        if (TRANSLATION_CACHE.containsKey(identifier)) {
            return TRANSLATION_CACHE.get(identifier);
        }
        String idString = identifier.toString();
        String path = identifier.getPath();
        if (LAST_LANG_INSTANCE.has(idString)) {
            TRANSLATION_CACHE.put(identifier, (Component)Component.translatable((String)idString));
        } else if (MusicIdentifier.isBiome(identifier)) {
            TRANSLATION_CACHE.put(identifier, (Component)Component.translatable((String)"music.format.biome", (Object[])new Object[]{Component.translatable((String)("biome." + identifier.getNamespace() + "." + path.split("\\.", 3)[2]))}));
        } else if (MusicIdentifier.isDimension(identifier)) {
            TRANSLATION_CACHE.put(identifier, (Component)Component.translatable((String)"music.format.dimension", (Object[])new Object[]{Component.translatable((String)path)}));
        } else if (MusicIdentifier.isDisc(identifier)) {
            TRANSLATION_CACHE.put(identifier, (Component)Component.translatable((String)"music.format.disc", (Object[])new Object[]{Component.translatable((String)path)}));
        } else if (MusicIdentifier.isMisc(identifier)) {
            TRANSLATION_CACHE.put(identifier, (Component)Component.translatable((String)"music.format.misc", (Object[])new Object[]{Component.translatable((String)path)}));
        }
        return TRANSLATION_CACHE.getOrDefault(identifier, (Component)Component.translatable((String)idString));
    }
}

