/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.client.SoundEventRegistry;
import com.github.charlyb01.music_control.mixin.SoundSetAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;

public class MusicCategories {
    public static final ArrayList<String> CATEGORIES = new ArrayList<String>(Arrays.asList("all", "default", "disc"));
    public static final ArrayList<String> NAMESPACES = new ArrayList<String>(List.of("minecraft"));
    public static final LinkedList<ResourceLocation> PLAYED_MUSICS = new LinkedList();

    private MusicCategories() {
    }

    public static void init(Minecraft client) {
        if (MusicControlClient.init) {
            PLAYED_MUSICS.clear();
            Music.MUSIC_BY_NAMESPACE.clear();
            Music.MUSIC_BY_EVENT.clear();
            Music.EVENTS.clear();
            SoundEventRegistry.BIOME_MUSIC_MAP.clear();
        } else {
            MusicControlClient.init = true;
        }
        RandomSource random = RandomSource.createNewThreadLocalInstance();
        HashSet<Music> musics = new HashSet<Music>();
        HashSet<Music> discs = new HashSet<Music>();
        Music.MUSIC_BY_NAMESPACE.put("all", musics);
        Music.MUSIC_BY_NAMESPACE.put("disc", discs);
        for (SoundEvent soundEvent : BuiltInRegistries.SOUND_EVENT) {
            ResourceKey<Biome> biomeRegistryKey;
            String[] split;
            ResourceLocation event = soundEvent.getLocation();
            if (!event.getPath().contains("music")) continue;
            if (!Music.EVENTS.contains(event) && !Music.BLACK_LISTED_EVENTS.contains(event)) {
                Music.EVENTS.add(event);
                Music.MUSIC_BY_EVENT.put(event, new HashSet());
            }
            if ((split = event.getPath().split("\\.")).length <= 0 || (biomeRegistryKey = SoundEventRegistry.NAME_BIOME_MAP.get(ResourceLocation.fromNamespaceAndPath((String)event.getNamespace(), (String)split[split.length - 1]))) == null) continue;
            SoundEventRegistry.BIOME_MUSIC_MAP.put(biomeRegistryKey, soundEvent);
        }
        for (ResourceLocation eventIdentifier : client.getSoundManager().getAvailableSounds()) {
            if (client.getSoundManager().getSoundEvent(eventIdentifier) == null) continue;
            List<Weighted<Sound>> sounds = ((SoundSetAccessor)client.getSoundManager().getSoundEvent(eventIdentifier)).getSounds();
            String namespace = eventIdentifier.getNamespace();
            String path = eventIdentifier.getPath();
            if (!path.contains("music")) continue;
            for (Weighted<Sound> soundContainer : sounds) {
                if (!(soundContainer instanceof Sound)) continue;
                ResourceLocation musicIdentifier = ((Sound)soundContainer.getSound(random)).getLocation();
                Music music = new Music(musicIdentifier);
                Optional<Music> optionalMusic = musics.stream().filter(music1 -> music1.getIdentifier().equals((Object)musicIdentifier)).findAny();
                if (optionalMusic.isPresent()) {
                    music = optionalMusic.get();
                    music.addEvent(eventIdentifier);
                    continue;
                }
                if (path.contains("music_disc")) {
                    discs.add(music);
                }
                musics.add(music);
                music.addEvent(eventIdentifier);
                if (namespace.equals("minecraft")) continue;
                HashSet customMusics = Music.MUSIC_BY_NAMESPACE.computeIfAbsent(namespace, k -> new HashSet());
                customMusics.add(music);
                if (CATEGORIES.contains(namespace)) continue;
                CATEGORIES.add(namespace);
                NAMESPACES.add(namespace);
            }
        }
        if (!CATEGORIES.contains(MusicControlClient.currentCategory)) {
            MusicControlClient.currentCategory = "default";
        }
    }

    public static void changeCategory(boolean nextCategory) {
        int index;
        int n = index = nextCategory ? (CATEGORIES.indexOf(MusicControlClient.currentCategory) + 1) % CATEGORIES.size() : CATEGORIES.indexOf(MusicControlClient.currentCategory) - 1;
        if (index < 0) {
            index = CATEGORIES.size() - 1;
        }
        MusicControlClient.currentCategory = CATEGORIES.get(index);
    }
}

