/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.Utils;
import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.categories.MusicCategories;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.client.SoundEventRegistry;
import com.github.charlyb01.music_control.config.DimensionEventChance;
import com.github.charlyb01.music_control.config.MiscEventChance;
import com.github.charlyb01.music_control.config.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MusicIdentifier {
    private MusicIdentifier() {
    }

    public static HashSet<Music> getListFromEvent(ResourceLocation eventId, Player player, Level world, RandomSource random) {
        boolean playerNotNull;
        HashSet<Music> musics = new HashSet<Music>();
        if (ModConfig.get().general.event.miscEventChance.equals((Object)MiscEventChance.HALF) && random.nextBoolean()) {
            musics.addAll(MusicIdentifier.getListFromEvent(eventId));
            MusicIdentifier.addDimensionEvent(musics, world, random);
            return musics;
        }
        boolean bl = playerNotNull = player != null;
        if (playerNotNull && player.isFallFlying()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.PLAYER_FLYING)));
        }
        if (playerNotNull && player.isPassenger()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.PLAYER_RIDING)));
        }
        if (Utils.isNight(world)) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.TIME_NIGHT)));
        }
        if (world.isRaining()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.WEATHER_RAIN)));
        }
        if (world.isThundering()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.WEATHER_THUNDER)));
        }
        if (!ModConfig.get().general.event.miscEventChance.equals((Object)MiscEventChance.PROPORTIONAL) && !musics.isEmpty()) {
            return musics;
        }
        musics.addAll(MusicIdentifier.getListFromEvent(eventId));
        MusicIdentifier.addDimensionEvent(musics, world, random);
        return musics;
    }

    private static void addDimensionEvent(HashSet<Music> musics, Level world, RandomSource random) {
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.FALLBACK)) {
            return;
        }
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.NEVER)) {
            return;
        }
        HashSet<Music> dimensionMusic = MusicIdentifier.getListFromEvent(MusicIdentifier.getDimension((ResourceKey<Level>)world.dimension()));
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.HALF)) {
            if (random.nextBoolean()) {
                return;
            }
            if (!dimensionMusic.isEmpty()) {
                musics.clear();
            }
        }
        musics.addAll(dimensionMusic);
    }

    public static HashSet<Music> getListFromEvent(ResourceLocation eventId) {
        HashSet<Music> musics = new HashSet<Music>();
        HashSet<ResourceLocation> checkedEvents = new HashSet<ResourceLocation>();
        ArrayList<ResourceLocation> eventsToCheck = new ArrayList<ResourceLocation>();
        eventsToCheck.add(eventId);
        while (!eventsToCheck.isEmpty()) {
            ResourceLocation event = (ResourceLocation)eventsToCheck.removeFirst();
            if (checkedEvents.contains(event)) continue;
            musics.addAll((Collection<Music>)Music.MUSIC_BY_EVENT.get(event));
            checkedEvents.add(event);
            if (!Music.EVENTS_OF_EVENT.containsKey(event)) continue;
            eventsToCheck.addAll((Collection)Music.EVENTS_OF_EVENT.get(event));
        }
        return musics;
    }

    public static ResourceLocation getFromList(HashSet<Music> musics, RandomSource random) {
        ResourceLocation music;
        if (musics.isEmpty()) {
            return null;
        }
        int size = musics.size();
        while (MusicCategories.PLAYED_MUSICS.size() >= Math.min(ModConfig.get().general.misc.musicQueue, size)) {
            MusicCategories.PLAYED_MUSICS.poll();
        }
        ArrayList<Music> musicList = new ArrayList<Music>(musics);
        while (MusicCategories.PLAYED_MUSICS.contains(music = musicList.remove(random.nextInt(size--)).getIdentifier())) {
        }
        MusicCategories.PLAYED_MUSICS.add(music);
        return music;
    }

    public static ResourceLocation getFromCategory(RandomSource random) {
        if (Music.MUSIC_BY_NAMESPACE.containsKey(MusicControlClient.currentCategory)) {
            HashSet<Music> musics = Music.MUSIC_BY_NAMESPACE.get(MusicControlClient.currentCategory);
            return MusicIdentifier.getFromList(musics, random);
        }
        return null;
    }

    private static ResourceLocation getDimension(ResourceKey<Level> world) {
        ResourceLocation eventId = world.equals((Object)Level.NETHER) ? MusicIdentifier.getFromSoundEvent(SoundEventRegistry.NETHER) : (world.equals((Object)Level.END) ? MusicIdentifier.getFromSoundEvent((Holder.Reference<SoundEvent>)SoundEvents.MUSIC_END) : MusicIdentifier.getFromSoundEvent((Holder.Reference<SoundEvent>)SoundEvents.MUSIC_GAME));
        return eventId;
    }

    public static ResourceLocation getFallback(ResourceKey<Level> world, boolean creative, RandomSource random) {
        HashSet<Music> musics = null;
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.FALLBACK)) {
            musics = MusicIdentifier.getListFromEvent(MusicIdentifier.getDimension(world));
        }
        if ((musics == null || musics.isEmpty()) && ModConfig.get().general.event.creativeEventFallback && creative) {
            musics = MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent((Holder.Reference<SoundEvent>)SoundEvents.MUSIC_CREATIVE));
        }
        return musics == null || musics.isEmpty() ? Music.EMPTY_MUSIC_ID : MusicIdentifier.getFromList(musics, random);
    }

    public static ResourceLocation getFromSoundEvent(Holder.Reference<SoundEvent> soundEvent) {
        return ((SoundEvent)soundEvent.value()).getLocation();
    }

    public static boolean isDimension(ResourceLocation identifier) {
        return identifier.equals((Object)MusicIdentifier.getFromSoundEvent((Holder.Reference<SoundEvent>)SoundEvents.MUSIC_GAME)) || identifier.equals((Object)MusicIdentifier.getFromSoundEvent(SoundEventRegistry.NETHER)) || identifier.equals((Object)MusicIdentifier.getFromSoundEvent((Holder.Reference<SoundEvent>)SoundEvents.MUSIC_END));
    }

    public static boolean isBiome(ResourceLocation identifier) {
        String path = identifier.getPath();
        return path.startsWith("music.overworld.") || path.startsWith("music.nether.") || path.startsWith("music.end.");
    }

    public static boolean isDisc(ResourceLocation identifier) {
        return identifier.getPath().startsWith("music_disc");
    }

    public static boolean isMisc(ResourceLocation identifier) {
        return identifier.getPath().startsWith("music.misc.");
    }
}

