/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.client;

import com.github.charlyb01.music_control.Utils;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.gui.MusicControlGUI;
import com.github.charlyb01.music_control.gui.MusicControlScreen;
import com.github.charlyb01.music_control.imixin.GameOptionsAccess;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.cottonmc.cotton.gui.GuiDescription;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;

public class MusicKeyBinding {
    private static KeyMapping previousMusic;
    private static KeyMapping nextMusic;
    private static KeyMapping pauseResume;
    private static KeyMapping loopMusic;
    private static KeyMapping previousCategory;
    private static KeyMapping nextCategory;
    private static KeyMapping printMusic;
    private static KeyMapping volumeUp;
    private static KeyMapping volumeDown;
    private static KeyMapping openMenu;

    public static void register() {
        MusicKeyBinding.registerKeys();
        MusicKeyBinding.registerEvents();
    }

    private static void registerKeys() {
        previousMusic = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.previousMusic", InputConstants.Type.KEYSYM, 263, "category.music_control.title"));
        nextMusic = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.nextMusic", InputConstants.Type.KEYSYM, 262, "category.music_control.title"));
        pauseResume = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.pause", InputConstants.Type.KEYSYM, 344, "category.music_control.title"));
        loopMusic = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.loop", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.music_control.title"));
        previousCategory = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.previousCategory", InputConstants.Type.KEYSYM, 266, "category.music_control.title"));
        nextCategory = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.nextCategory", InputConstants.Type.KEYSYM, 267, "category.music_control.title"));
        printMusic = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.print", InputConstants.Type.KEYSYM, 345, "category.music_control.title"));
        volumeUp = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.volumeUp", InputConstants.Type.KEYSYM, 265, "category.music_control.title"));
        volumeDown = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.volumeDown", InputConstants.Type.KEYSYM, 264, "category.music_control.title"));
        openMenu = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.music_control.openMenu", InputConstants.Type.KEYSYM, 77, "category.music_control.title"));
    }

    private static void registerEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            int volume;
            while (previousMusic.consumeClick()) {
                MusicControlClient.previousMusic = true;
            }
            while (nextMusic.consumeClick()) {
                MusicControlClient.nextMusic = true;
            }
            while (pauseResume.consumeClick()) {
                MusicControlClient.pauseResume = true;
            }
            while (loopMusic.consumeClick()) {
                boolean bl = MusicControlClient.loopMusic = !MusicControlClient.loopMusic;
                if (MusicControlClient.loopMusic) {
                    Utils.print(client, (Component)Component.translatable((String)"music.loop.on"));
                    continue;
                }
                Utils.print(client, (Component)Component.translatable((String)"music.loop.off"));
            }
            while (previousCategory.consumeClick()) {
                MusicControlClient.previousCategory = true;
            }
            while (nextCategory.consumeClick()) {
                MusicControlClient.nextCategory = true;
            }
            while (printMusic.consumeClick()) {
                MusicControlClient.printMusic = true;
            }
            while (volumeUp.consumeClick()) {
                volume = Math.round(client.options.getSoundSourceVolume(SoundSource.MUSIC) * 100.0f);
                volume = Math.min(volume + ModConfig.get().general.misc.volumeIncrement, 100);
                ((GameOptionsAccess)client.options).music_control$setSoundCategoryVolume(SoundSource.MUSIC, (float)volume / 100.0f);
                client.options.save();
                Utils.print(client, (Component)Component.translatable((String)"music.volume", (Object[])new Object[]{volume}));
            }
            while (volumeDown.consumeClick()) {
                volume = Math.round(client.options.getSoundSourceVolume(SoundSource.MUSIC) * 100.0f);
                volume = Math.max(volume - ModConfig.get().general.misc.volumeIncrement, 0);
                ((GameOptionsAccess)client.options).music_control$setSoundCategoryVolume(SoundSource.MUSIC, (float)volume / 100.0f);
                client.options.save();
                Utils.print(client, (Component)Component.translatable((String)"music.volume", (Object[])new Object[]{volume}));
            }
            while (openMenu.consumeClick()) {
                client.setScreen((Screen)new MusicControlScreen((GuiDescription)new MusicControlGUI(client)));
            }
        });
    }
}

