/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.gui.components;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.config.FilterOperator;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.gui.components.Button;
import com.github.charlyb01.music_control.gui.components.FilterListPanel;
import com.github.charlyb01.music_control.gui.components.TextFilter;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;

public class ButtonListPanel
extends WBox {
    private final FilterListPanel<ResourceLocation, Button> items;
    private final TextFilter filter;

    public ButtonListPanel(List<ResourceLocation> data, BiConsumer<ResourceLocation, Button> onClicked, int width, int height) {
        this(data, onClicked, width, height, true, true);
    }

    public ButtonListPanel(List<ResourceLocation> data, BiConsumer<ResourceLocation, Button> onClicked, int width, int height, boolean hasFilter, boolean sortData) {
        super(Axis.VERTICAL);
        BiConsumer<ResourceLocation, Button> configurator = (identifier, button) -> {
            button.setText(Music.getTranslatedText(identifier).getString());
            button.setOnClick(() -> onClicked.accept((ResourceLocation)identifier, (Button)((Object)button)));
        };
        if (sortData) {
            data.sort(Music.TRANSLATED_ORDER);
        }
        this.items = new FilterListPanel<ResourceLocation, Button>(data, () -> new Button(width), configurator);
        if (hasFilter && height > TextFilter.HEIGHT) {
            this.filter = new TextFilter(this::runFilter, width);
            this.add((WWidget)this.filter, width, TextFilter.HEIGHT);
            this.add((WWidget)this.items, width, height - TextFilter.HEIGHT);
            this.layout();
        } else {
            this.filter = null;
            this.add((WWidget)this.items, width, height);
        }
    }

    public void update() {
        if (this.filter != null) {
            this.filter.runOnChange();
        }
    }

    private void runFilter(String s) {
        if (s == null || s.isEmpty()) {
            this.items.runFilter(null);
            return;
        }
        boolean operatorModifier = false;
        String[] wordsRaw = s.split(" ");
        ArrayList<String> words = new ArrayList<String>();
        for (String word : wordsRaw) {
            if (word.isEmpty()) continue;
            if (word.charAt(0) == '&') {
                operatorModifier = true;
                if (word.length() <= 1) continue;
                words.add(word.substring(1));
                continue;
            }
            words.add(word);
        }
        boolean andOperator = ModConfig.get().cosmetics.gui.filterOperator.equals((Object)FilterOperator.AND) ^ operatorModifier;
        this.items.runFilter((D id) -> {
            for (String word : words) {
                if (andOperator && !this.match(word, (ResourceLocation)id)) {
                    return false;
                }
                if (andOperator || !this.match(word, (ResourceLocation)id)) continue;
                return true;
            }
            return andOperator;
        });
    }

    private boolean match(String word, ResourceLocation id) {
        boolean doesMatch;
        boolean inverted;
        boolean bl = inverted = word.charAt(0) == '!';
        if (inverted && word.length() < 2) {
            return false;
        }
        int firstCharIndex = inverted ? 1 : 0;
        char firstChar = word.charAt(firstCharIndex);
        if (firstChar == '@') {
            doesMatch = id.getNamespace().contains(word.substring(firstCharIndex + 1));
        } else if (firstChar == '#') {
            doesMatch = id.getPath().contains(word.substring(firstCharIndex + 1));
        } else {
            String evaluated = Music.getTranslatedText(id).getString();
            doesMatch = firstChar == '$' ? evaluated.contains(word.substring(firstCharIndex + 1)) : evaluated.toLowerCase().contains(word.substring(firstCharIndex).toLowerCase());
        }
        return doesMatch ^ inverted;
    }
}

