/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.client.SoundEventRegistry;
import com.github.charlyb01.music_control.config.DimensionEventChance;
import com.github.charlyb01.music_control.config.ModConfig;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    private volatile boolean pause;
    @Shadow
    @Final
    private MusicManager musicManager;
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sound/SoundManager;tick(Z)V")})
    private void musicTrackerAlwaysTick(CallbackInfo ci) {
        if (ModConfig.get().general.misc.musicDontPause && this.pause) {
            this.musicManager.tick();
        }
    }

    @ModifyReturnValue(method={"getMusicType"}, at={@At(value="RETURN", ordinal=2)})
    private Music useEndMusic(Music original) {
        return ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.FALLBACK) ? this.getMusicFromMap(original) : original;
    }

    @ModifyReturnValue(method={"getMusicType"}, at={@At(value="RETURN", ordinal=4)})
    private Music cancelCreativeBeforeBiome(Music original) {
        return ModConfig.get().general.event.creativeEventFallback ? this.getMusicFromMap(original) : original;
    }

    @ModifyReturnValue(method={"getMusicType"}, at={@At(value="RETURN", ordinal=2)})
    private Music useMapInsteadOfOptionalMusic(Music original) {
        return this.getMusicFromMap(original);
    }

    @Unique
    private Music getMusicFromMap(Music elseOption) {
        Holder registryEntry = this.player.level().getBiome(this.player.blockPosition());
        ResourceKey registryKey = registryEntry.unwrapKey().orElse(null);
        if (registryKey != null && SoundEventRegistry.BIOME_MUSIC_MAP.containsKey(registryKey)) {
            return Musics.createGameMusic((Holder)Holder.direct((Object)SoundEventRegistry.BIOME_MUSIC_MAP.get(registryKey)));
        }
        return ((Biome)registryEntry.value()).getBackgroundMusic().orElse(elseOption);
    }
}

