/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.Utils;
import com.github.charlyb01.music_control.categories.MusicCategories;
import com.github.charlyb01.music_control.categories.MusicIdentifier;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.imixin.PauseResumeIMixin;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicTrackerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    private int nextSongDelay;
    @Shadow
    private SoundInstance currentMusic;
    @Unique
    private boolean displayPrompted = false;

    @Shadow
    public abstract void startPlaying(Music var1);

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void playMusic(Music type, CallbackInfo ci) {
        ResourceLocation eventId = type != null ? ((SoundEvent)type.getEvent().value()).getLocation() : null;
        MusicControlClient.inCustomTracking = false;
        if (!MusicControlClient.init || this.minecraft.level == null) {
            return;
        }
        if (!MusicControlClient.shouldPlay) {
            MusicControlClient.shouldPlay = true;
            this.nextSongDelay = Utils.getTimer(this.random);
            ci.cancel();
            return;
        }
        boolean wasPlaying = this.minecraft.getSoundManager().isActive(this.currentMusic);
        this.minecraft.getSoundManager().stop(this.currentMusic);
        if (MusicControlClient.musicSelected != null) {
            MusicControlClient.currentMusic = MusicControlClient.musicSelected;
            MusicControlClient.musicSelected = null;
        } else if (MusicControlClient.previousMusic) {
            ResourceLocation music;
            MusicControlClient.previousMusic = false;
            if (wasPlaying) {
                MusicCategories.PLAYED_MUSICS.pollLast();
            }
            if ((music = MusicCategories.PLAYED_MUSICS.peekLast()) != null) {
                MusicControlClient.currentMusic = music;
            }
        } else if (!MusicControlClient.loopMusic) {
            if (eventId != null && MusicControlClient.currentCategory.equals("default") && com.github.charlyb01.music_control.categories.Music.MUSIC_BY_EVENT.containsKey(eventId)) {
                boolean creative = this.minecraft.player != null && this.minecraft.player.isCreative();
                HashSet<com.github.charlyb01.music_control.categories.Music> musics = MusicIdentifier.getListFromEvent(eventId, (Player)this.minecraft.player, (Level)this.minecraft.level, this.random);
                MusicControlClient.currentMusic = musics.isEmpty() ? MusicIdentifier.getFallback((ResourceKey<Level>)this.minecraft.level.dimension(), creative, this.random) : MusicIdentifier.getFromList(musics, this.random);
            } else {
                MusicControlClient.currentMusic = MusicIdentifier.getFromCategory(this.random);
            }
        }
        if (MusicControlClient.currentMusic != null || type != null) {
            this.currentMusic = SimpleSoundInstance.forMusic((SoundEvent)(MusicControlClient.currentMusic == null ? (SoundEvent)type.getEvent().value() : SoundEvent.createVariableRangeEvent((ResourceLocation)MusicControlClient.currentMusic)));
        }
        if (this.currentMusic.getSound() != SoundManager.EMPTY_SOUND) {
            this.minecraft.getSoundManager().play(this.currentMusic);
            MusicControlClient.inCustomTracking = true;
        }
        this.displayMusic();
        this.nextSongDelay = Utils.getTimer(this.random);
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMusic(CallbackInfo ci) {
        this.handlePreviousMusicKey();
        this.handleNextMusicKey();
        this.handleResumePauseKey();
        this.handleChangeCategoryKey();
        this.handleDisplayMusicKey();
        if (MusicControlClient.inCustomTracking) {
            if (this.minecraft == null || !MusicControlClient.init || this.minecraft.level == null || this.currentMusic == null || !this.minecraft.getSoundManager().isActive(this.currentMusic)) {
                MusicControlClient.inCustomTracking = false;
            } else {
                ci.cancel();
            }
        }
        if (MusicControlClient.isPaused && (this.currentMusic == null || this.minecraft != null && !this.minecraft.getSoundManager().isActive(this.currentMusic))) {
            ++this.nextSongDelay;
        }
    }

    @Unique
    private void displayMusic() {
        if (ModConfig.get().cosmetics.display.atMusicStart || MusicControlClient.categoryChanged) {
            this.printMusic();
        }
        if (MusicControlClient.categoryChanged) {
            MusicControlClient.categoryChanged = false;
        }
    }

    @Unique
    private void printPaused() {
        Utils.print(this.minecraft, (Component)Component.translatable((String)"music.paused"));
    }

    @Unique
    private void printMusic() {
        String currentMusic;
        if (this.minecraft.level == null) {
            return;
        }
        String string = currentMusic = this.currentMusic == null || this.currentMusic.getSound() == null ? com.github.charlyb01.music_control.categories.Music.EMPTY_MUSIC : this.currentMusic.getSound().getLocation().toString();
        if (currentMusic.equals(com.github.charlyb01.music_control.categories.Music.EMPTY_MUSIC)) {
            if (!this.displayPrompted) {
                return;
            }
            this.displayPrompted = false;
            if (ModConfig.get().cosmetics.display.remainingSeconds) {
                double remaining = (double)this.nextSongDelay / 20.0;
                Utils.print(this.minecraft, (Component)Component.translatable((String)"music.no_playing_with_time", (Object[])new Object[]{String.valueOf(remaining)}));
            } else {
                Utils.print(this.minecraft, (Component)Component.translatable((String)"music.no_playing"));
            }
        } else {
            MutableComponent category = Component.translatableWithFallback((String)("music.category." + MusicControlClient.currentCategory), (String)MusicControlClient.currentCategory.toUpperCase().replace('_', ' '));
            MutableComponent music = Component.translatable((String)currentMusic);
            MutableComponent content = MusicControlClient.categoryChanged ? Component.translatable((String)"music.format.category", (Object[])new Object[]{category, music}) : music;
            Utils.print(this.minecraft, (Component)Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{content}));
        }
    }

    @Unique
    private void handlePreviousMusicKey() {
        if (MusicControlClient.previousMusic) {
            if (MusicControlClient.isPaused) {
                MusicControlClient.previousMusic = false;
                this.printPaused();
            } else {
                this.displayPrompted = ModConfig.get().cosmetics.display.atMusicStart;
                this.startPlaying(null);
            }
        }
    }

    @Unique
    private void handleNextMusicKey() {
        if (MusicControlClient.nextMusic) {
            MusicControlClient.nextMusic = false;
            MusicControlClient.loopMusic = false;
            if (MusicControlClient.isPaused) {
                this.printPaused();
            } else {
                this.displayPrompted = ModConfig.get().cosmetics.display.atMusicStart;
                this.startPlaying(this.minecraft.getSituationalMusic());
            }
        }
    }

    @Unique
    private void handleResumePauseKey() {
        if (MusicControlClient.pauseResume) {
            MusicControlClient.pauseResume = false;
            if (MusicControlClient.isPaused) {
                MusicControlClient.isPaused = false;
                ((PauseResumeIMixin)this.minecraft.getSoundManager()).music_control$resumeMusic();
                if (this.minecraft.player != null) {
                    Utils.print(this.minecraft, (Component)Component.translatable((String)"music.play"));
                }
            } else {
                MusicControlClient.isPaused = true;
                ((PauseResumeIMixin)this.minecraft.getSoundManager()).music_control$pauseMusic();
                if (this.minecraft.player != null) {
                    Utils.print(this.minecraft, (Component)Component.translatable((String)"music.pause"));
                }
            }
        }
    }

    @Unique
    private void handleChangeCategoryKey() {
        if (MusicControlClient.nextCategory || MusicControlClient.previousCategory) {
            if (MusicControlClient.isPaused) {
                this.printPaused();
            } else {
                MusicControlClient.categoryChanged = true;
                MusicCategories.changeCategory(MusicControlClient.nextCategory);
                this.startPlaying(this.minecraft.getSituationalMusic());
            }
            if (MusicControlClient.nextCategory) {
                MusicControlClient.nextCategory = false;
            } else {
                MusicControlClient.previousCategory = false;
            }
        }
    }

    @Unique
    private void handleDisplayMusicKey() {
        if (MusicControlClient.printMusic) {
            MusicControlClient.printMusic = false;
            this.displayPrompted = true;
            this.printMusic();
        }
    }
}

