/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.categories.Music;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/client/sound/SoundManager$SoundList"})
public class SoundListMixin {
    @Shadow
    @Final
    Map<ResourceLocation, WeighedSoundEvents> registry;

    @Inject(method={"register"}, at={@At(value="TAIL")})
    private void addEverySound(ResourceLocation id, SoundEventRegistration entry, CallbackInfo ci, @Local(ordinal=0) ResourceProvider resourceFactory) {
        if (entry.isReplace()) {
            Music.EVENTS_OF_EVENT.remove(id);
        }
        for (Sound sound : entry.getSounds()) {
            ResourceLocation identifier = sound.getLocation();
            if (!identifier.getPath().contains("music") && !identifier.getPath().contains("records")) continue;
            switch (sound.getType()) {
                case FILE: {
                    if (!SoundManager.validateSoundResource((Sound)sound, (ResourceLocation)id, (ResourceProvider)resourceFactory)) break;
                    WeighedSoundEvents newWeightedSoundSet = new WeighedSoundEvents(id, entry.getSubtitle());
                    this.registry.put(identifier, newWeightedSoundSet);
                    newWeightedSoundSet.addSound((Weighted)sound);
                    break;
                }
                case SOUND_EVENT: {
                    if (!Music.EVENTS_OF_EVENT.containsKey(id)) {
                        Music.EVENTS_OF_EVENT.put(id, new HashSet());
                    }
                    Music.EVENTS_OF_EVENT.get(id).add(identifier);
                }
            }
        }
    }
}

