/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.imixin.PauseResumeIMixin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={SoundManager.class})
public class SoundManagerMixin
implements PauseResumeIMixin {
    @Shadow
    @Final
    private SoundEngine soundEngine;

    @Inject(method={"prepare(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)Lnet/minecraft/client/sound/SoundManager$SoundList;"}, at={@At(value="HEAD")})
    private void resetEventsOfEvent(ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfoReturnable<SoundManager.Preparations> cir) {
        Music.EVENTS_OF_EVENT.clear();
    }

    @Inject(method={"pauseAll"}, at={@At(value="TAIL")})
    private void dontPauseMusic(CallbackInfo ci) {
        if (ModConfig.get().general.misc.musicDontPause && !MusicControlClient.isPaused) {
            this.music_control$resumeMusic();
        }
    }

    @Inject(method={"resumeAll"}, at={@At(value="TAIL")})
    private void dontResumeIfPaused(CallbackInfo ci) {
        if (MusicControlClient.isPaused) {
            this.music_control$pauseMusic();
        }
    }

    @Override
    public void music_control$pauseMusic() {
        ((PauseResumeIMixin)this.soundEngine).music_control$pauseMusic();
    }

    @Override
    public void music_control$resumeMusic() {
        ((PauseResumeIMixin)this.soundEngine).music_control$resumeMusic();
    }
}

