/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.categories.MusicCategories;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.imixin.PauseResumeIMixin;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.audio.Channel;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public abstract class SoundSystemMixin
implements PauseResumeIMixin {
    @Shadow
    @Final
    private Options options;
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;
    @Shadow
    @Final
    private Multimap<SoundSource, SoundInstance> instanceBySource;

    @Shadow
    protected abstract void tickNonPaused();

    @Inject(method={"reloadSounds"}, at={@At(value="TAIL")})
    private void reinitializeMusicCategories(CallbackInfo ci) {
        MusicCategories.init(Minecraft.getInstance());
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void delayIfNoSound(CallbackInfo ci) {
        if (this.options.getSoundSourceVolume(SoundSource.MASTER) <= 0.0f || this.options.getSoundSourceVolume(SoundSource.MUSIC) <= 0.0f) {
            MusicControlClient.shouldPlay = false;
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="HEAD")})
    private void alwaysTick(boolean paused, CallbackInfo ci) {
        if (ModConfig.get().general.misc.musicDontPause && paused) {
            this.tickNonPaused();
        }
    }

    @Inject(method={"play(Lnet/minecraft/client/sound/SoundInstance;)V"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/sound/SoundInstance;getSound()Lnet/minecraft/client/sound/Sound;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void printRecord(SoundInstance soundInstance, CallbackInfo ci, @Local(ordinal=0) Sound sound) {
        ResourceLocation record = sound.getLocation();
        if (soundInstance.getLocation().getPath().contains("music_disc")) {
            Minecraft client = Minecraft.getInstance();
            client.gui.setNowPlaying((Component)Component.translatable((String)record.toString()));
            if (MusicControlClient.currentCategory.equals("all") || MusicControlClient.currentCategory.equals("disc")) {
                MusicCategories.PLAYED_MUSICS.add(record);
            }
        }
    }

    @Override
    public void music_control$pauseMusic() {
        if (!this.loaded) {
            return;
        }
        this.instanceBySource.get((Object)SoundSource.MUSIC).forEach(soundInstance -> {
            ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(soundInstance);
            if (sourceManager != null) {
                sourceManager.execute(Channel::pause);
            }
        });
    }

    @Override
    public void music_control$resumeMusic() {
        if (!this.loaded) {
            return;
        }
        this.instanceBySource.get((Object)SoundSource.MUSIC).forEach(soundInstance -> {
            ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(soundInstance);
            if (sourceManager != null) {
                sourceManager.execute(Channel::unpause);
            }
        });
    }
}

