/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.particle.GalacticUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.client.screen.widget.TestGear;
import it.hurts.octostudios.octolib.util.RenderUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class TestGearScreen
extends Screen {
    Tween tween = Tween.create().setLoops(-1);
    boolean shouldTick;

    public TestGearScreen() {
        super((Component)Component.empty());
        this.tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_ON, (float)2.0f)));
        this.tween.tweenInterval(0.5);
        this.tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        this.tween.tweenInterval(0.5);
        this.tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        this.tween.tweenInterval(0.5);
        this.tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        this.tween.tweenInterval(0.5);
        this.tween.start();
    }

    public void tick() {
        super.tick();
        if (Minecraft.getInstance().player.tickCount % 20 == 0) {
            this.shouldTick = true;
        }
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new TestGear((int)((float)this.width / 2.0f - 64.0f), (int)((float)this.height / 2.0f - 64.0f)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.shouldTick) {
            this.shouldTick = false;
            GalacticUIParticle particle = new GalacticUIParticle(1.25f, 40, mouseX, mouseY, UIParticle.Layer.SCREEN, 0.0f);
            particle.setScreen(this);
            particle.setRollVelocity(new Random().nextFloat(-5.0f, 5.0f));
            particle.instantiate();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/particle/sga_").withSuffix("a.png"));
        RenderUtils.renderTilingTexture(guiGraphics.pose(), 10.0f, 10.0f, 0.0f, 0.0f, 8.0f, 8.0f, 80.0f, 80.0f, 0.0f, true, false);
    }

    public void onClose() {
        super.onClose();
        if (this.tween != null) {
            this.tween.kill();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

