/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.component;

import io.netty.buffer.Unpooled;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.sync.ComponentPacketWriter;
import org.ladysnake.cca.api.v3.component.sync.PlayerSyncPredicate;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.base.asm.CcaBootstrap;

@ApiStatus.NonExtendable
public abstract class ComponentKey<C extends Component> {
    private final ResourceLocation id;
    private final Class<C> componentClass;

    public final ResourceLocation getId() {
        return this.id;
    }

    public final Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Contract(pure=true)
    @Nullable
    public C getNullable(Object provider) {
        return this.getInternal(((ComponentProvider)provider).getComponentContainer());
    }

    public final C get(Object provider) {
        C component = this.getInternal(((ComponentProvider)provider).getComponentContainer());
        assert (component == null || this.getComponentClass().isInstance(component));
        if (component == null) {
            try {
                throw new NoSuchElementException(String.valueOf(provider) + " provides no component of type " + String.valueOf(this.getId()));
            }
            catch (NullPointerException e) {
                NoSuchElementException e1 = new NoSuchElementException(String.valueOf(this.getId()) + " not available");
                e1.addSuppressed(e);
                throw e1;
            }
        }
        return component;
    }

    public final Optional<C> maybeGet(@Nullable Object provider) {
        if (provider instanceof ComponentProvider) {
            ComponentProvider p = (ComponentProvider)provider;
            return Optional.ofNullable(this.getInternal(p.getComponentContainer()));
        }
        return Optional.empty();
    }

    @Contract(pure=true)
    public boolean isProvidedBy(Object provider) {
        return this.getNullable(provider) != null;
    }

    public void sync(Object provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, synced, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, packetWriter, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter, PlayerSyncPredicate predicate) {
        for (ServerPlayer player : ((ComponentProvider)provider).getRecipientsForComponentSync()) {
            this.syncWith(player, (ComponentProvider)provider, packetWriter, predicate);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(ServerPlayer player, ComponentProvider provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.syncWith(player, provider, synced, synced);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(ServerPlayer player, ComponentProvider provider, ComponentPacketWriter writer, PlayerSyncPredicate predicate) {
        if (predicate.shouldSyncWith(player)) {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.serverLevel().registryAccess());
            writer.writeSyncPacket(buf, player);
            CustomPacketPayload payload = provider.toComponentPacket(this, predicate.isRequiredOnClient(), buf);
            if (payload != null) {
                if (ServerPlayNetworking.canSend((ServerPlayer)player, (CustomPacketPayload.Type)payload.type())) {
                    ServerPlayNetworking.getSender((ServerPlayer)player).sendPacket(payload, PacketSendListener.thenRun(() -> ((RegistryFriendlyByteBuf)buf).release()));
                } else {
                    if (predicate.isRequiredOnClient()) {
                        player.connection.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)("This server requires Cardinal Components API (unhandled packet: " + String.valueOf(payload.type().id()) + ")" + ComponentsInternals.getClientOptionalModAdvice())));
                    }
                    buf.release();
                }
            } else {
                buf.release();
            }
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[\"" + String.valueOf(this.id) + "\"]";
    }

    @ApiStatus.Internal
    protected ComponentKey(ResourceLocation id, Class<C> componentClass) {
        if (!CcaBootstrap.INSTANCE.isGenerated(this.getClass())) {
            throw new IllegalStateException();
        }
        this.componentClass = componentClass;
        this.id = id;
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    @Nullable
    public abstract C getInternal(ComponentContainer var1);

    @ApiStatus.Internal
    public C getFromContainer(ComponentContainer container) {
        return (C)((Component)Objects.requireNonNull(this.getInternal(container)));
    }
}

