/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.component.sync;

import com.demonwav.mcdev.annotations.CheckEnv;
import com.demonwav.mcdev.annotations.Env;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.ComponentPacketWriter;
import org.ladysnake.cca.api.v3.component.sync.PlayerSyncPredicate;

public interface AutoSyncedComponent
extends Component,
ComponentPacketWriter,
PlayerSyncPredicate {
    @Override
    default public boolean shouldSyncWith(ServerPlayer player) {
        return true;
    }

    @Override
    @Contract(mutates="param1")
    default public void writeSyncPacket(RegistryFriendlyByteBuf buf, ServerPlayer recipient) {
        CompoundTag tag = new CompoundTag();
        this.writeToNbt(tag, (HolderLookup.Provider)buf.registryAccess());
        buf.writeNbt((Tag)tag);
    }

    @CheckEnv(value=Env.CLIENT)
    default public void applySyncPacket(RegistryFriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag != null) {
            this.readFromNbt(tag, (HolderLookup.Provider)buf.registryAccess());
        }
    }
}

