/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base;

import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.internal.base.ComponentsInternals;

public abstract class AbstractComponentContainer
implements ComponentContainer {
    public static final String NBT_KEY = "cardinal_components";

    @Override
    public void copyFrom(ComponentContainer other, HolderLookup.Provider registryLookup) {
        for (ComponentKey<?> key : this.keys()) {
            Object theirs = key.getInternal(other);
            Object ours = key.getInternal(this);
            assert (ours != null);
            if (theirs == null || ours.equals(theirs)) continue;
            if (ours instanceof CopyableComponent) {
                CopyableComponent copyable = (CopyableComponent)ours;
                copyable.copyFrom(theirs, registryLookup);
                continue;
            }
            CompoundTag tag = new CompoundTag();
            theirs.writeToNbt(tag, registryLookup);
            ours.readFromNbt(tag, registryLookup);
        }
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider registryLookup) {
        if (tag.contains(NBT_KEY, 9)) {
            ListTag componentList = tag.getList(NBT_KEY, 10);
            for (int i = 0; i < componentList.size(); ++i) {
                Object component;
                CompoundTag nbt = componentList.getCompound(i);
                ComponentKey<?> type = ComponentRegistry.get(ResourceLocation.parse((String)nbt.getString("componentId")));
                if (type == null || (component = type.getInternal(this)) == null) continue;
                component.readFromNbt(nbt, registryLookup);
            }
        } else if (tag.contains(NBT_KEY, 10)) {
            CompoundTag componentMap = tag.getCompound(NBT_KEY);
            for (ComponentKey<?> key : this.keys()) {
                String keyId = key.getId().toString();
                if (!componentMap.contains(keyId, 10)) continue;
                Object component = key.getInternal(this);
                assert (component != null);
                component.readFromNbt(componentMap.getCompound(keyId), registryLookup);
                componentMap.remove(keyId);
            }
            ComponentsInternals.logDeserializationWarnings(componentMap.getAllKeys());
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag, HolderLookup.Provider registryLookup) {
        if (this.hasComponents()) {
            CompoundTag componentMap = null;
            CompoundTag componentTag = new CompoundTag();
            for (ComponentKey<?> type : this.keys()) {
                Object component = type.getFromContainer(this);
                component.writeToNbt(componentTag, registryLookup);
                if (componentTag.isEmpty()) continue;
                if (componentMap == null) {
                    componentMap = new CompoundTag();
                    tag.put(NBT_KEY, (Tag)componentMap);
                }
                componentMap.put(type.getId().toString(), (Tag)componentTag);
                componentTag = new CompoundTag();
            }
        }
        return tag;
    }

    public String toString() {
        Iterator<ComponentKey<?>> i = this.keys().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            ComponentKey<?> key = i.next();
            Object value = key.getInternal(this);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

