/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base;

import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.base.UnknownComponentException;

public final class CcaClientInternals {
    public static <T extends ComponentUpdatePayload<?>> void registerComponentSync(CustomPacketPayload.Type<T> packetId, BiFunction<T, ClientPlayNetworking.Context, Optional<? extends org.ladysnake.cca.api.v3.component.Component>> getter) {
        ClientPlayNetworking.registerGlobalReceiver(packetId, (payload, ctx) -> {
            try {
                ((Optional)getter.apply(payload, ctx)).ifPresent(c -> {
                    if (c instanceof AutoSyncedComponent) {
                        AutoSyncedComponent synced = (AutoSyncedComponent)c;
                        synced.applySyncPacket(payload.buf());
                    }
                });
            }
            catch (UnknownComponentException e) {
                ctx.player().connection.onDisconnect(new DisconnectionDetails((Component)Component.literal((String)(e.getMessage() + "\n(you are probably missing a mod installed on the server)" + ComponentsInternals.getClientOptionalModAdvice()))));
            }
            finally {
                payload.buf().release();
            }
        });
    }
}

