/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base;

import org.jetbrains.annotations.ApiStatus;
import org.ladysnake.cca.internal.base.ComponentsInternals;

public abstract class LazyDispatcher {
    private volatile State state = State.UNLOADED;
    private final String likelyInitTrigger;

    protected LazyDispatcher(String likelyInitTrigger) {
        this.likelyInitTrigger = likelyInitTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized() {
        if (this.state == State.ERRED) {
            throw new IllegalStateException("Initialization failed, check the log above for likely causes");
        }
        if (this.state != State.LOADED) {
            LazyDispatcher lazyDispatcher = this;
            synchronized (lazyDispatcher) {
                if (this.state == State.LOADING) {
                    this.onCircularLoading();
                } else if (this.state == State.UNLOADED) {
                    this.state = State.LOADING;
                    try {
                        this.init();
                        this.state = State.LOADED;
                        this.postInit();
                    }
                    catch (Throwable t) {
                        this.state = State.ERRED;
                        ComponentsInternals.LOGGER.fatal("[Cardinal Components API] Initialization failed: ", t);
                        throw t;
                    }
                }
            }
        }
    }

    protected void onCircularLoading() {
        throw new IllegalStateException("Circular loading issue, a mod is probably " + this.likelyInitTrigger + " in the wrong place");
    }

    protected boolean requiresInitialization() {
        return this.state == State.UNLOADED;
    }

    @ApiStatus.OverrideOnly
    protected abstract void init();

    public void checkLoading(Class<?> ownerClass, String methodName) {
        if (this.state != State.LOADING) {
            throw new IllegalStateException(ownerClass.getSimpleName() + "#" + methodName + " called at the wrong time");
        }
    }

    protected void postInit() {
    }

    static enum State {
        UNLOADED,
        LOADING,
        LOADED,
        ERRED;

    }
}

