/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base.asm;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.internal.base.AbstractComponentContainer;
import org.ladysnake.cca.internal.base.QualifiedComponentFactory;
import org.ladysnake.cca.internal.base.asm.AsmGeneratedCallback;
import org.ladysnake.cca.internal.base.asm.CalledByAsm;
import org.ladysnake.cca.internal.base.asm.CcaBootstrap;
import org.ladysnake.cca.internal.base.asm.StaticComponentLoadingException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;

public final class CcaAsmHelper {
    public static final boolean DEBUG_CLASSES = Boolean.getBoolean("cca.debug.asm");
    public static final int ASM_VERSION = 589824;
    public static final String COMPONENT = Type.getInternalName(Component.class);
    public static final String COMPONENT_CONTAINER = Type.getInternalName(ComponentContainer.class);
    public static final String COMPONENT_TYPE = Type.getInternalName(ComponentKey.class);
    public static final String DYNAMIC_COMPONENT_CONTAINER_IMPL = Type.getInternalName(AbstractComponentContainer.class);
    public static final String IDENTIFIER = FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft.resources.ResourceLocation").replace('.', '/');
    public static final String EVENT = Type.getInternalName(Event.class);
    public static final String STATIC_COMPONENT_CONTAINER = CcaAsmHelper.createClassName("GeneratedComponentContainer");
    public static final String STATIC_CONTAINER_GETTER_DESC = "()L" + COMPONENT + ";";
    public static final String STATIC_COMPONENT_TYPE = CcaAsmHelper.createClassName("ComponentType");
    public static final String STATIC_CONTAINER_FACTORY = CcaAsmHelper.createClassName("GeneratedContainerFactory");
    public static final String ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC;
    private static final List<AsmGeneratedCallbackInfo> asmGeneratedCallbacks;
    private static final AtomicInteger nextDebugId;

    private static List<AsmGeneratedCallbackInfo> findAsmComponentCallbacks() {
        ArrayList<AsmGeneratedCallbackInfo> asmGeneratedCallbacks = new ArrayList<AsmGeneratedCallbackInfo>();
        for (Method containerMethod : ComponentContainer.class.getMethods()) {
            @Nullable AsmGeneratedCallback annotation = containerMethod.getAnnotation(AsmGeneratedCallback.class);
            if (annotation == null) continue;
            Class<? extends Component> componentClass = annotation.value();
            boolean found = false;
            for (Method componentMethod : componentClass.getDeclaredMethods()) {
                if (!componentMethod.isAnnotationPresent(CalledByAsm.class)) continue;
                asmGeneratedCallbacks.add(new AsmGeneratedCallbackInfo(containerMethod.getName(), componentClass, componentMethod.getName()));
                found = true;
            }
            if (found) continue;
            throw new IllegalStateException("No ASM-called method found in " + String.valueOf(componentClass));
        }
        return asmGeneratedCallbacks;
    }

    public static String createClassName(String name) {
        return CcaAsmHelper.class.getPackageName().replace('.', '/') + "/_generated_$" + name;
    }

    public static Class<?> generateClass(ClassNode classNode, boolean hidden, @Nullable Object classData) throws IOException {
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return CcaAsmHelper.generateClass(writer, classNode.name, hidden, classData);
    }

    private static Class<?> generateClass(ClassWriter classWriter, String className, boolean hidden, @Nullable Object classData) throws IOException {
        try {
            if (!hidden && classData != null) {
                throw new IllegalArgumentException("Class data is only supported for hidden classes");
            }
            byte[] bytes = classWriter.toByteArray();
            if (DEBUG_CLASSES) {
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)new CheckClassAdapter(null), 0);
                Path path = Paths.get(classReader.getClassName() + "_" + nextDebugId.getAndIncrement() + ".class", new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, new OpenOption[0]);
            }
            if (hidden) {
                if (classData == null) {
                    return MethodHandles.lookup().defineHiddenClass(bytes, false, MethodHandles.Lookup.ClassOption.STRONG).lookupClass();
                }
                return MethodHandles.lookup().defineHiddenClassWithClassData(bytes, classData, false, MethodHandles.Lookup.ClassOption.STRONG).lookupClass();
            }
            return MethodHandles.lookup().defineClass(bytes);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new IOException("Failed to generate class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new StaticComponentLoadingException("Failed to define class " + className, e);
        }
    }

    public static String getJavaIdentifierName(ResourceLocation identifier) {
        return identifier.toString().replace(':', '$').replace('/', '$').replace('.', '\u00a4').replace('-', '\u00a3');
    }

    public static String getStaticStorageGetterName(ResourceLocation identifier) {
        return "get$" + CcaAsmHelper.getJavaIdentifierName(identifier);
    }

    public static Method findSam(Class<?> callbackClass) {
        if (!callbackClass.isInterface()) {
            throw CcaAsmHelper.badFunctionalInterface(callbackClass);
        }
        Method ret = null;
        for (Method m : callbackClass.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            if (ret != null) {
                throw CcaAsmHelper.badFunctionalInterface(callbackClass);
            }
            ret = m;
        }
        if (ret == null) {
            throw CcaAsmHelper.badFunctionalInterface(callbackClass);
        }
        return ret;
    }

    private static IllegalArgumentException badFunctionalInterface(Class<?> callbackClass) {
        return new IllegalArgumentException(String.valueOf(callbackClass) + " is not a functional interface!");
    }

    @Deprecated(forRemoval=true)
    public static <I> Class<? extends ComponentContainer> spinComponentContainer(Class<? super I> componentFactoryType, Map<ComponentKey<?>, I> componentFactories, Map<ComponentKey<?>, Class<? extends Component>> componentImpls) throws IOException {
        LinkedHashMap merged = new LinkedHashMap();
        for (Map.Entry<ComponentKey<?>, I> entry : componentFactories.entrySet()) {
            merged.put(entry.getKey(), new QualifiedComponentFactory<I>(entry.getValue(), componentImpls.get(entry.getKey()), Set.of()));
        }
        return CcaAsmHelper.spinComponentContainer(componentFactoryType, merged);
    }

    public static <I> Class<? extends ComponentContainer> spinComponentContainer(Class<? super I> componentFactoryType, Map<ComponentKey<?>, QualifiedComponentFactory<I>> componentFactories) throws IOException {
        CcaBootstrap.INSTANCE.ensureInitialized();
        QualifiedComponentFactory.checkDependenciesSatisfied(componentFactories);
        Map<ComponentKey<?>, QualifiedComponentFactory<I>> sorted = QualifiedComponentFactory.sort(componentFactories);
        String containerImplName = STATIC_COMPONENT_CONTAINER + "Impl";
        String componentFactoryName = Type.getInternalName(componentFactoryType);
        Method sam = CcaAsmHelper.findSam(componentFactoryType);
        String samDescriptor = Type.getMethodDescriptor((Method)sam);
        Class<?>[] factoryArgs = sam.getParameterTypes();
        Type[] actualCtorArgs = new Type[factoryArgs.length];
        for (int i = 0; i < factoryArgs.length; ++i) {
            actualCtorArgs[i] = Type.getType(factoryArgs[i]);
        }
        String ctorDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])actualCtorArgs);
        ClassNode classNode = new ClassNode(589824);
        classNode.visit(61, 17, containerImplName, null, STATIC_COMPONENT_CONTAINER, null);
        String factoryFieldDescriptor = Type.getDescriptor(componentFactoryType);
        classNode.visitField(26, "componentKeys", "Ljava/util/Set;", "Ljava/util/Set<Lorg/ladysnake/cca/api/v3/component/ComponentKey<*>;>;", null);
        MethodVisitor keys = classNode.visitMethod(1, "keys", "()Ljava/util/Set;", "()Ljava/util/Set<Lorg/ladysnake/cca/api/v3/component/ComponentKey<*>;>;", null);
        keys.visitFieldInsn(178, containerImplName, "componentKeys", "Ljava/util/Set;");
        keys.visitInsn(176);
        keys.visitEnd();
        MethodVisitor hasComponents = classNode.visitMethod(1, "hasComponents", "()Z", null, null);
        hasComponents.visitCode();
        hasComponents.visitInsn(sorted.isEmpty() ? 3 : 4);
        hasComponents.visitInsn(172);
        hasComponents.visitEnd();
        MethodVisitor init = classNode.visitMethod(1, "<init>", ctorDesc, null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, STATIC_COMPONENT_CONTAINER, "<init>", ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC, false);
        LinkedHashMap<AsmGeneratedCallbackInfo, MethodVisitor> callbackMethods = new LinkedHashMap<AsmGeneratedCallbackInfo, MethodVisitor>();
        for (AsmGeneratedCallbackInfo asmGeneratedCallbackInfo : asmGeneratedCallbacks) {
            MethodVisitor visitor = classNode.visitMethod(1, asmGeneratedCallbackInfo.containerCallbackName(), "()V", null, null);
            visitor.visitCode();
            callbackMethods.put(asmGeneratedCallbackInfo, visitor);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            ResourceLocation identifier = ((ComponentKey)entry.getKey()).getId();
            String componentFieldName = CcaAsmHelper.getJavaIdentifierName(identifier);
            Class<Component> impl = ((QualifiedComponentFactory)entry.getValue()).impl();
            String componentFieldDescriptor = Type.getDescriptor(impl);
            String factoryFieldName = CcaAsmHelper.getFactoryFieldName(identifier);
            classNode.visitField(26, factoryFieldName, factoryFieldDescriptor, null, null).visitEnd();
            classNode.visitField(18, componentFieldName, componentFieldDescriptor, null, null).visitEnd();
            init.visitFieldInsn(178, containerImplName, factoryFieldName, factoryFieldDescriptor);
            for (int i = 0; i < factoryArgs.length; ++i) {
                init.visitVarInsn(25, i + 1);
            }
            init.visitMethodInsn(185, componentFactoryName, sam.getName(), samDescriptor, true);
            init.visitLdcInsn((Object)("Component factory " + String.valueOf(((QualifiedComponentFactory)entry.getValue()).factory().getClass()) + " for " + String.valueOf(identifier) + " produced a null component"));
            init.visitMethodInsn(184, "java/util/Objects", "requireNonNull", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
            init.visitTypeInsn(192, Type.getInternalName(impl));
            init.visitVarInsn(25, 0);
            init.visitInsn(95);
            init.visitFieldInsn(181, containerImplName, componentFieldName, componentFieldDescriptor);
            MethodVisitor getter = classNode.visitMethod(1, CcaAsmHelper.getStaticStorageGetterName(identifier), STATIC_CONTAINER_GETTER_DESC, null, null);
            getter.visitVarInsn(25, 0);
            getter.visitFieldInsn(180, containerImplName, componentFieldName, componentFieldDescriptor);
            getter.visitInsn(176);
            getter.visitEnd();
            for (Map.Entry e : callbackMethods.entrySet()) {
                if (!((AsmGeneratedCallbackInfo)e.getKey()).componentClass().isAssignableFrom(impl)) continue;
                CcaAsmHelper.generateCallbackImpl(containerImplName, (MethodVisitor)e.getValue(), componentFieldName, impl, componentFieldDescriptor, ((AsmGeneratedCallbackInfo)e.getKey()).componentCallbackName());
            }
        }
        init.visitInsn(177);
        init.visitEnd();
        for (Map.Entry entry : callbackMethods.entrySet()) {
            ((MethodVisitor)entry.getValue()).visitInsn(177);
            ((MethodVisitor)entry.getValue()).visitEnd();
        }
        Object[] classData = new Object[sorted.size() + 1];
        classData[0] = Collections.unmodifiableSet(new ReferenceArraySet(sorted.keySet()));
        MethodVisitor methodVisitor = classNode.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        ConstantDynamic constantClassData = CcaAsmHelper.constantClassData(Object[].class);
        methodVisitor.visitLdcInsn((Object)constantClassData);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(50);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Set.class));
        methodVisitor.visitFieldInsn(179, containerImplName, "componentKeys", Type.getDescriptor(Set.class));
        int i = 1;
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>> entry : sorted.entrySet()) {
            classData[i] = entry.getValue().factory();
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i);
            methodVisitor.visitInsn(50);
            methodVisitor.visitTypeInsn(192, Type.getInternalName(componentFactoryType));
            methodVisitor.visitFieldInsn(179, containerImplName, CcaAsmHelper.getFactoryFieldName(entry.getKey().getId()), Type.getDescriptor(componentFactoryType));
            ++i;
        }
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(177);
        methodVisitor.visitEnd();
        return CcaAsmHelper.generateClass(classNode, true, classData).asSubclass(ComponentContainer.class);
    }

    @NotNull
    public static ConstantDynamic constantClassData(Class<?> dataType) {
        return new ConstantDynamic("_", Type.getDescriptor(dataType), new Handle(6, Type.getInternalName(MethodHandles.class), "classData", MethodType.methodType(Object.class, MethodHandles.Lookup.class, String.class, Class.class).descriptorString(), false), new Object[0]);
    }

    private static void generateCallbackImpl(String containerImplName, MethodVisitor tick, String componentFieldName, Class<? extends Component> impl, String componentFieldDescriptor, String target) {
        tick.visitVarInsn(25, 0);
        tick.visitFieldInsn(180, containerImplName, componentFieldName, componentFieldDescriptor);
        if (impl.isInterface()) {
            tick.visitMethodInsn(185, Type.getInternalName(impl), target, "()V", true);
        } else {
            tick.visitMethodInsn(182, Type.getInternalName(impl), target, "()V", false);
        }
    }

    private static String getFactoryFieldName(ResourceLocation identifier) {
        return CcaAsmHelper.getJavaIdentifierName(identifier) + "$factory";
    }

    static {
        asmGeneratedCallbacks = CcaAsmHelper.findAsmComponentCallbacks();
        try {
            ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC = Type.getConstructorDescriptor(AbstractComponentContainer.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find one or more method descriptors", e);
        }
        nextDebugId = new AtomicInteger();
    }

    record AsmGeneratedCallbackInfo(String containerCallbackName, Class<? extends Component> componentClass, String componentCallbackName) {
    }
}

