/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base.asm;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentFactory;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.internal.base.ComponentRegistrationInitializer;
import org.ladysnake.cca.internal.base.LazyDispatcher;
import org.ladysnake.cca.internal.base.asm.CcaAsmHelper;
import org.ladysnake.cca.internal.base.asm.CcaBootstrap;
import org.ladysnake.cca.internal.base.asm.StaticComponentLoadingException;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public abstract class StaticComponentPluginBase<T, I>
extends LazyDispatcher {
    private final ComponentContainer.Factory.Builder<T> containerFactoryBuilder;

    protected StaticComponentPluginBase(String likelyInitTrigger, Class<T> providerClass) {
        super(likelyInitTrigger);
        this.containerFactoryBuilder = ComponentContainer.Factory.builder(providerClass);
    }

    public static <I> Class<? extends I> spinContainerFactory(Class<? super I> containerFactoryType, Class<? extends ComponentContainer> containerImpl, List<Class<?>> actualFactoryParams) throws IOException {
        MethodHandle containerCtor;
        CcaBootstrap.INSTANCE.ensureInitialized();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object[] constructors = containerImpl.getConstructors();
        if (constructors.length != 1) {
            throw new IllegalStateException("Ambiguous constructor declarations in " + String.valueOf(containerImpl) + ": " + Arrays.toString(constructors));
        }
        Method factorySam = CcaAsmHelper.findSam(containerFactoryType);
        if (factorySam.getParameterCount() != actualFactoryParams.size()) {
            throw new IllegalArgumentException("Actual argument list length mismatches with factory SAM: " + String.valueOf(actualFactoryParams) + " and " + String.valueOf(factorySam));
        }
        if (((Constructor)constructors[0]).getParameterCount() != factorySam.getParameterCount()) {
            throw new IllegalArgumentException("Factory SAM parameter count should be the same as container constructor (found " + String.valueOf(factorySam) + " for " + String.valueOf(constructors[0]) + ")");
        }
        Class<?>[] factoryParamClasses = factorySam.getParameterTypes();
        Type[] factoryArgs = new Type[factoryParamClasses.length];
        for (int i = 0; i < factoryParamClasses.length; ++i) {
            if (!factoryParamClasses[i].isAssignableFrom(actualFactoryParams.get(i))) {
                throw new IllegalArgumentException("Container factory parameter %s is not assignable from specified actual parameter %s(%s, %s)".formatted(factoryParamClasses[i].getSimpleName(), actualFactoryParams.get(i).getSimpleName(), factorySam, actualFactoryParams));
            }
            factoryArgs[i] = Type.getType(factoryParamClasses[i]);
        }
        ClassNode containerFactoryWriter = new ClassNode(589824);
        String factoryImplName = CcaAsmHelper.STATIC_CONTAINER_FACTORY;
        containerFactoryWriter.visit(61, 17, factoryImplName, null, "java/lang/Object", new String[]{Type.getInternalName(containerFactoryType)});
        MethodVisitor init = containerFactoryWriter.visitMethod(1, "<init>", "()V", null, null);
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        init.visitInsn(177);
        init.visitEnd();
        MethodVisitor createContainer = containerFactoryWriter.visitMethod(1, factorySam.getName(), Type.getMethodDescriptor((Method)factorySam), null, null);
        ConstantDynamic constantClassData = CcaAsmHelper.constantClassData(MethodHandle.class);
        createContainer.visitLdcInsn((Object)constantClassData);
        for (int i = 0; i < actualFactoryParams.size(); ++i) {
            createContainer.visitVarInsn(factoryArgs[i].getOpcode(21), i + 1);
            if (factoryArgs[i].getSort() != 10 && factoryArgs[i].getSort() != 9) continue;
            createContainer.visitTypeInsn(192, Type.getInternalName(actualFactoryParams.get(i)));
        }
        createContainer.visitMethodInsn(182, Type.getInternalName(MethodHandle.class), "invokeExact", Type.getMethodDescriptor((Method)factorySam), false);
        createContainer.visitInsn(176);
        createContainer.visitEnd();
        containerFactoryWriter.visitEnd();
        try {
            containerCtor = lookup.findConstructor(containerImpl, MethodType.methodType(Void.TYPE, factorySam.getParameterTypes())).asType(MethodType.methodType(factorySam.getReturnType(), factorySam.getParameterTypes()));
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not find container constructor", e);
        }
        Class<?> ret = CcaAsmHelper.generateClass(containerFactoryWriter, true, containerCtor);
        return ret;
    }

    public static ComponentContainer createEmptyContainer() {
        try {
            Class<ComponentContainer> containerCls = CcaAsmHelper.spinComponentContainer(Runnable.class, Collections.emptyMap());
            return containerCls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new StaticComponentLoadingException("Failed to generate empty component container", e);
        }
    }

    protected ComponentContainer.Factory<T> buildContainerFactory() {
        this.ensureInitialized();
        return this.containerFactoryBuilder.build();
    }

    @Override
    protected void init() {
        StaticComponentPluginBase.processInitializers(this.getEntrypoints(), this::dispatchRegistration);
    }

    public static <I> void processInitializers(Collection<EntrypointContainer<I>> entrypoints, Consumer<I> action) {
        for (EntrypointContainer<I> entrypoint : entrypoints) {
            try {
                action.accept(entrypoint.getEntrypoint());
            }
            catch (Throwable e) {
                ModMetadata metadata = entrypoint.getProvider().getMetadata();
                throw new StaticComponentLoadingException(String.format("Exception while registering static component factories for %s (%s)", metadata.getName(), metadata.getId()), e);
            }
        }
    }

    public static <I extends ComponentRegistrationInitializer> Collection<EntrypointContainer<I>> getComponentEntrypoints(String key, Class<I> type) {
        List generic = FabricLoader.getInstance().getEntrypointContainers("cardinal-components", ComponentRegistrationInitializer.class);
        ArrayList<EntrypointContainer<I>> specific = new ArrayList<EntrypointContainer<I>>(FabricLoader.getInstance().getEntrypointContainers(key, type));
        for (EntrypointContainer container : generic) {
            if (!type.isInstance(container.getEntrypoint())) continue;
            EntrypointContainer c = container;
            specific.add(c);
        }
        return specific;
    }

    protected abstract Collection<EntrypointContainer<I>> getEntrypoints();

    protected abstract void dispatchRegistration(I var1);

    protected <C extends Component> void register(ComponentKey<C> key, ComponentFactory<T, ? extends C> factory) {
        this.containerFactoryBuilder.component(key, factory);
    }

    protected <C extends Component> void register(ComponentKey<? super C> key, Class<C> impl, ComponentFactory<T, ? extends C> factory) {
        this.containerFactoryBuilder.component(key, impl, factory);
    }
}

