/*
 * Decompiled with CFR 0.152.
 */
package com.starlotte.cobblemon_move_inspector.mixin.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.gui.battle.subscreen.BattleMoveSelection;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.starlotte.cobblemon_move_inspector.client.MoveEffectivenessLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BattleMoveSelection.MoveTile.class})
public abstract class BattleMoveSelectionGUIMixin {
    @Shadow
    public MoveTemplate moveTemplate;

    @Shadow
    public abstract boolean isHovered(double var1, double var3);

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    public void tooltipRenderMixin(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) throws ScriptException, IOException {
        if (this.isHovered(mouseX, mouseY)) {
            List enemies;
            ClientBattle battle;
            ArrayList<MutableComponent> tooltipInfo = new ArrayList<MutableComponent>();
            List description = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)this.moveTemplate.getDescription(), 250, Style.EMPTY.withColor(this.moveTemplate.getElementalType().getHue()));
            for (FormattedText formattedText : description) {
                tooltipInfo.add(MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(formattedText.getString())).withStyle(ChatFormatting.GRAY));
            }
            if (this.moveTemplate.getDamageCategory() != DamageCategories.INSTANCE.getSTATUS() || this.moveTemplate.getAccuracy() != -1.0 || this.moveTemplate.getEffectChances().length != 0) {
                tooltipInfo.add(Component.empty());
                if (this.moveTemplate.getPower() > 0.0) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.power", (Object[])new Object[]{(int)this.moveTemplate.getPower()}));
                }
                if (this.moveTemplate.getAccuracy() > 0.0) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.accuracy", (Object[])new Object[]{(int)this.moveTemplate.getAccuracy()}));
                }
                if (this.moveTemplate.getEffectChances().length != 0) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.effect", (Object[])new Object[]{Math.round(this.moveTemplate.getEffectChances()[0])}));
                }
            }
            if ((battle = CobblemonClient.INSTANCE.getBattle()) != null && !(enemies = battle.getSide2().getActors()).isEmpty() && this.moveTemplate.getTarget() != MoveTarget.self) {
                ElementalType opponentSecondType;
                ClientBattleActor firstPlayer = (ClientBattleActor)enemies.get(0);
                ClientBattlePokemon firstActivePokemon = ((ActiveClientBattlePokemon)firstPlayer.getActivePokemon().get(0)).getBattlePokemon();
                Pokemon properties = firstActivePokemon.getProperties().create();
                ElementalType opponentFirstType = properties.getPrimaryType();
                float effectiveness = MoveEffectivenessLookup.getModifier(this.moveTemplate, opponentFirstType, opponentSecondType = properties.getSecondaryType(), firstPlayer.getUuid());
                if (effectiveness == 0.0f) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.immune").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                } else if (effectiveness > 1.0f) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.effective", (Object[])new Object[]{Float.valueOf(effectiveness)}).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}));
                } else if (effectiveness < 1.0f) {
                    tooltipInfo.add(Component.translatable((String)"move.inspector.ineffective", (Object[])new Object[]{Float.valueOf(effectiveness)}).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                }
            }
            context.renderComponentTooltip(Minecraft.getInstance().font, tooltipInfo, mouseX, mouseY);
        }
    }
}

