/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.properties.CabinetryShape;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CabinetryBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<CabinetryShape> SHAPE = EnumProperty.create((String)"shape", CabinetryShape.class);
    protected static final VoxelShape TOP_SHAPE_NORTH = Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_DEFAULT_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_DEFAULT_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_DEFAULT_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_DEFAULT_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_DEFAULT_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_DEFAULT_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_DEFAULT_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_INNER_CORNER_LEFT_NORTH = Shapes.or((VoxelShape)Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)11.0, (double)15.0));
    protected static final VoxelShape BOTTOM_INNER_CORNER_LEFT_EAST = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_LEFT_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_INNER_CORNER_LEFT_SOUTH = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_LEFT_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_INNER_CORNER_LEFT_WEST = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_LEFT_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_INNER_CORNER_RIGHT_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)11.0, (double)15.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)11.0, (double)15.0));
    protected static final VoxelShape BOTTOM_INNER_CORNER_RIGHT_EAST = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_RIGHT_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_INNER_CORNER_RIGHT_SOUTH = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_RIGHT_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_INNER_CORNER_RIGHT_WEST = ShapeUtil.rotateShape(BOTTOM_INNER_CORNER_RIGHT_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_LEFT_NORTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0)});
    protected static final VoxelShape BOTTOM_OUTER_CORNER_LEFT_EAST = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_LEFT_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_LEFT_SOUTH = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_LEFT_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_LEFT_WEST = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_LEFT_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_RIGHT_NORTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)11.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0)});
    protected static final VoxelShape BOTTOM_OUTER_CORNER_RIGHT_EAST = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_RIGHT_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_RIGHT_SOUTH = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_RIGHT_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_OUTER_CORNER_RIGHT_WEST = ShapeUtil.rotateShape(BOTTOM_OUTER_CORNER_RIGHT_NORTH, Direction.WEST);

    public CabinetryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)((Object)CabinetryShape.DEFAULT))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (LevelReader)context.getLevel(), context.getClickedPos())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (LevelReader)level, pos)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        CabinetryShape shape = (CabinetryShape)((Object)state.getValue(SHAPE));
        VoxelShape topShape = TOP_SHAPE_NORTH;
        VoxelShape bottomShape = switch (shape) {
            case CabinetryShape.INNER_CORNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield BOTTOM_INNER_CORNER_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield BOTTOM_INNER_CORNER_LEFT_SOUTH;
                    }
                    case WEST: {
                        yield BOTTOM_INNER_CORNER_LEFT_WEST;
                    }
                }
                yield BOTTOM_INNER_CORNER_LEFT_NORTH;
            }
            case CabinetryShape.INNER_CORNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield BOTTOM_INNER_CORNER_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield BOTTOM_INNER_CORNER_RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield BOTTOM_INNER_CORNER_RIGHT_WEST;
                    }
                }
                yield BOTTOM_INNER_CORNER_RIGHT_NORTH;
            }
            case CabinetryShape.OUTER_CORNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield BOTTOM_OUTER_CORNER_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield BOTTOM_OUTER_CORNER_LEFT_SOUTH;
                    }
                    case WEST: {
                        yield BOTTOM_OUTER_CORNER_LEFT_WEST;
                    }
                }
                yield BOTTOM_OUTER_CORNER_LEFT_NORTH;
            }
            case CabinetryShape.OUTER_CORNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield BOTTOM_OUTER_CORNER_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield BOTTOM_OUTER_CORNER_RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield BOTTOM_OUTER_CORNER_RIGHT_WEST;
                    }
                }
                yield BOTTOM_OUTER_CORNER_RIGHT_NORTH;
            }
            default -> {
                switch (facing) {
                    case EAST: {
                        yield BOTTOM_DEFAULT_SHAPE_EAST;
                    }
                    case SOUTH: {
                        yield BOTTOM_DEFAULT_SHAPE_SOUTH;
                    }
                    case WEST: {
                        yield BOTTOM_DEFAULT_SHAPE_WEST;
                    }
                }
                yield BOTTOM_DEFAULT_SHAPE_NORTH;
            }
        };
        return Shapes.or((VoxelShape)topShape, (VoxelShape)bottomShape);
    }

    private CabinetryShape getShape(BlockState state, LevelReader level, BlockPos pos) {
        Direction behind;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction front = this.getNeighborDirection(level, pos, facing.getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return CabinetryShape.OUTER_CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return CabinetryShape.OUTER_CORNER_LEFT;
            }
        }
        if ((behind = this.getNeighborDirection(level, pos, facing)) != null) {
            if (behind == facing.getClockWise()) {
                return CabinetryShape.INNER_CORNER_LEFT;
            }
            if (behind == facing.getCounterClockWise()) {
                return CabinetryShape.INNER_CORNER_RIGHT;
            }
        }
        return CabinetryShape.DEFAULT;
    }

    private Direction getNeighborDirection(LevelReader level, BlockPos pos, Direction side) {
        BlockState neighborState = level.getBlockState(pos.relative(side));
        if (neighborState.getBlock() instanceof CabinetryBlock) {
            return (Direction)neighborState.getValue((Property)FACING);
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

