/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.screen;

import com.lunazstudios.cobblefurnies.client.screen.FurniCrafterScreen;
import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ClientFurnicrafterRecipeIngredientTooltip
implements ClientTooltipComponent {
    private final FurniCrafterMenu menu;
    private final CountedIngredient material;
    private final Map<Integer, Integer> counted;

    public ClientFurnicrafterRecipeIngredientTooltip(FurniCrafterMenu menu, CountedIngredient material, Map<Integer, Integer> counted) {
        this.menu = menu;
        this.material = material;
        this.counted = counted;
    }

    public int getHeight() {
        return 18;
    }

    public int getWidth(Font font) {
        return 18 + font.width((FormattedText)this.getStack().getDisplayName());
    }

    public void renderImage(Font font, int start, int top, GuiGraphics graphics) {
        ItemStack stack = this.getStack().copy();
        stack.setCount(this.material.count());
        graphics.renderFakeItem(stack, start, top);
        graphics.renderItemDecorations(font, stack, start, top);
        MutableComponent name = stack.getHoverName().copy().withStyle(ChatFormatting.GRAY);
        graphics.drawString(font, (Component)name, start + 18 + 5, top + 4, -1);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        boolean hasEnough = this.menu.hasMaterials(this.material, this.counted);
        graphics.blit(FurniCrafterScreen.TEXTURE, start, top, hasEnough ? 246.0f : 240.0f, 40.0f, 6, 5, 256, 256);
        pose.popPose();
    }

    private ItemStack getStack() {
        ItemStack[] items = this.material.ingredient().getItems();
        int index = (int)(Util.getMillis() / 1000L % (long)items.length);
        return items[index];
    }
}

