/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.screen;

import com.lunazstudios.cobblefurnies.client.screen.FurniCrafterScreen;
import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class ClientFurnicrafterRecipeTooltip
implements ClientTooltipComponent {
    private final FurniCrafterMenu menu;
    private final FurniCraftingRecipe recipe;

    public ClientFurnicrafterRecipeTooltip(FurniCrafterMenu menu, FurniCraftingRecipe recipe) {
        this.menu = menu;
        this.recipe = recipe;
    }

    public int getHeight() {
        return 20;
    }

    public int getWidth(Font font) {
        return this.recipe.getMaterials().size() * 18;
    }

    public void renderImage(Font font, int start, int top, GuiGraphics graphics) {
        HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
        NonNullList<CountedIngredient> materials = this.recipe.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            CountedIngredient material = (CountedIngredient)materials.get(i);
            ItemStack copy = this.getStack(material).copy();
            copy.setCount(material.count());
            graphics.renderFakeItem(copy, start + i * 18, top);
            graphics.renderItemDecorations(font, copy, start + i * 18, top);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            boolean hasEnough = this.menu.hasMaterials(material, counted);
            graphics.blit(FurniCrafterScreen.TEXTURE, start + i * 18, top, hasEnough ? 246.0f : 240.0f, 40.0f, 6, 5, 256, 256);
            pose.popPose();
        }
    }

    private ItemStack getStack(CountedIngredient material) {
        ItemStack[] items = material.ingredient().getItems();
        int index = (int)(Util.getMillis() / 1000L % (long)items.length);
        return items[index];
    }
}

