/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SurvivalTrinketSlot
extends Slot
implements TrinketSlot {
    private final SlotGroup group;
    private final SlotType type;
    private final boolean alwaysVisible;
    private final int slotOffset;
    private final TrinketInventory trinketInventory;

    public SurvivalTrinketSlot(TrinketInventory inventory, int index, int x, int y, SlotGroup group, SlotType type, int slotOffset, boolean alwaysVisible) {
        super((Container)inventory, index, x, y);
        this.group = group;
        this.type = type;
        this.slotOffset = slotOffset;
        this.alwaysVisible = alwaysVisible;
        this.trinketInventory = inventory;
    }

    public boolean mayPlace(ItemStack stack) {
        return TrinketSlot.canInsert(stack, new SlotReference(this.trinketInventory, this.slotOffset), this.trinketInventory.getComponent().getEntity());
    }

    public boolean mayPickup(Player player) {
        ItemStack stack = this.getItem();
        return TrinketsApi.getTrinket(stack.getItem()).canUnequip(stack, new SlotReference(this.trinketInventory, this.slotOffset), (LivingEntity)player);
    }

    public boolean isActive() {
        if (this.alwaysVisible) {
            if (this.x < 0) {
                Level world = this.trinketInventory.getComponent().getEntity().level();
                if (world.isClientSide) {
                    InventoryScreen screen;
                    Minecraft client = Minecraft.getInstance();
                    Screen s = client.screen;
                    if (s instanceof InventoryScreen && (screen = (InventoryScreen)s).getRecipeBookComponent().isVisible()) {
                        return false;
                    }
                }
            }
            return true;
        }
        return this.isTrinketFocused();
    }

    @Override
    public boolean isTrinketFocused() {
        if (TrinketsClient.activeGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.activeType == this.type;
        }
        if (TrinketsClient.quickMoveGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.quickMoveType == this.type && TrinketsClient.quickMoveTimer > 0;
        }
        return false;
    }

    @Override
    public ResourceLocation getBackgroundIdentifier() {
        return this.type.getIcon();
    }

    @Override
    public SlotType getType() {
        return this.type;
    }
}

