/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class TrinketModifiers {
    public static Multimap<Holder<Attribute>, AttributeModifier> get(ItemStack stack, SlotReference slot, LivingEntity entity) {
        Multimap<Holder<Attribute>, AttributeModifier> map = TrinketsApi.getTrinket(stack.getItem()).getModifiers(stack, slot, entity, SlotAttributes.getIdentifier(slot));
        if (stack.has(TrinketsAttributeModifiersComponent.TYPE)) {
            for (TrinketsAttributeModifiersComponent.Entry entry : ((TrinketsAttributeModifiersComponent)stack.getOrDefault(TrinketsAttributeModifiersComponent.TYPE, (Object)TrinketsAttributeModifiersComponent.DEFAULT)).modifiers()) {
                map.put(entry.attribute(), (Object)entry.modifier());
            }
        }
        return map;
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> get(Trinket trinket, ItemStack stack, SlotReference slot, LivingEntity entity, ResourceLocation slotIdentifier) {
        Multimap<Holder<Attribute>, AttributeModifier> map = trinket.getModifiers(stack, slot, entity, slotIdentifier);
        if (stack.has(TrinketsAttributeModifiersComponent.TYPE)) {
            for (TrinketsAttributeModifiersComponent.Entry entry : ((TrinketsAttributeModifiersComponent)stack.getOrDefault(TrinketsAttributeModifiersComponent.TYPE, (Object)TrinketsAttributeModifiersComponent.DEFAULT)).modifiers()) {
                if (!entry.slot().isEmpty() && !entry.slot().get().equals(slot.inventory().getSlotType().getId())) continue;
                map.put(entry.attribute(), (Object)entry.modifier());
            }
        }
        return map;
    }
}

