/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class TrinketScreenManager {
    private static final ResourceLocation MORE_SLOTS = ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"textures/gui/more_slots.png");
    public static TrinketScreen currentScreen;
    public static Rect2i currentBounds;
    public static Rect2i typeBounds;
    public static Rect2i quickMoveBounds;
    public static Rect2i quickMoveTypeBounds;
    public static SlotGroup group;
    public static SlotGroup quickMoveGroup;

    public static void init(TrinketScreen screen) {
        currentScreen = screen;
        group = null;
        currentBounds = new Rect2i(0, 0, 0, 0);
    }

    public static void removeSelections() {
        TrinketsClient.activeGroup = null;
        TrinketsClient.quickMoveGroup = null;
    }

    public static void update(float mouseX, float mouseY) {
        Rect2i r;
        TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
        Slot focusedSlot = currentScreen.trinkets$getFocusedSlot();
        int x = currentScreen.trinkets$getX();
        int y = currentScreen.trinkets$getY();
        if (group != null) {
            TrinketSlot ts;
            if (TrinketsClient.activeType != null) {
                if (!typeBounds.contains(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
                    TrinketsClient.activeType = null;
                } else if (!(focusedSlot == null || focusedSlot instanceof TrinketSlot && (ts = (TrinketSlot)focusedSlot).getType() == TrinketsClient.activeType)) {
                    TrinketsClient.activeType = null;
                }
            }
            if (TrinketsClient.activeType == null) {
                if (!currentBounds.contains(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
                    TrinketsClient.activeGroup = null;
                    group = null;
                } else if (focusedSlot instanceof TrinketSlot) {
                    Point slotHeight;
                    ts = (TrinketSlot)focusedSlot;
                    int i = handler.trinkets$getSlotTypes(group).indexOf(ts.getType());
                    if (i >= 0 && (slotHeight = handler.trinkets$getSlotHeight(group, i)) != null) {
                        r = currentScreen.trinkets$getGroupRect(group);
                        int height = slotHeight.y();
                        if (height > 1) {
                            TrinketsClient.activeType = ts.getType();
                            typeBounds = new Rect2i(r.getX() + slotHeight.x() - 2, r.getY() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
                        }
                    }
                }
            }
        }
        if (group == null && quickMoveGroup != null) {
            if (quickMoveTypeBounds.contains(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
                Point slotHeight;
                TrinketsClient.activeGroup = quickMoveGroup;
                TrinketsClient.activeType = TrinketsClient.quickMoveType;
                int i = handler.trinkets$getSlotTypes(TrinketsClient.activeGroup).indexOf(TrinketsClient.activeType);
                if (i >= 0 && (slotHeight = handler.trinkets$getSlotHeight(TrinketsClient.activeGroup, i)) != null) {
                    Rect2i r2 = currentScreen.trinkets$getGroupRect(TrinketsClient.activeGroup);
                    int height = slotHeight.y();
                    if (height > 1) {
                        typeBounds = new Rect2i(r2.getX() + slotHeight.x() - 2, r2.getY() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
                    }
                }
                TrinketsClient.quickMoveGroup = null;
            } else if (quickMoveBounds.contains(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
                TrinketsClient.activeGroup = quickMoveGroup;
                TrinketsClient.quickMoveGroup = null;
            }
        }
        if (group == null) {
            Minecraft client = Minecraft.getInstance();
            for (SlotGroup g : TrinketsApi.getPlayerSlots((Player)client.player).values()) {
                r = currentScreen.trinkets$getGroupRect(g);
                if (r.getX() < 0 && currentScreen.trinkets$isRecipeBookOpen() || !r.contains(Math.round(mouseX) - x, Math.round(mouseY) - y)) continue;
                TrinketsClient.activeGroup = g;
                TrinketsClient.quickMoveGroup = null;
                break;
            }
        }
        if (group != TrinketsClient.activeGroup && (group = TrinketsClient.activeGroup) != null) {
            int slotsWidth = handler.trinkets$getSlotWidth(group) + 1;
            if (group.getSlotId() == -1) {
                --slotsWidth;
            }
            Rect2i r3 = currentScreen.trinkets$getGroupRect(group);
            currentBounds = new Rect2i(0, 0, 0, 0);
            if (r3 != null) {
                int l = (slotsWidth - 1) / 2 * 18;
                currentBounds = slotsWidth > 1 ? new Rect2i(r3.getX() - l - 3, r3.getY() - 3, slotsWidth * 18 + 5, 23) : r3;
                if (focusedSlot instanceof TrinketSlot) {
                    int height;
                    Point slotHeight;
                    TrinketSlot ts = (TrinketSlot)focusedSlot;
                    int i = handler.trinkets$getSlotTypes(group).indexOf(ts.getType());
                    if (i >= 0 && (slotHeight = handler.trinkets$getSlotHeight(group, i)) != null && (height = slotHeight.y()) > 1) {
                        TrinketsClient.activeType = ts.getType();
                        typeBounds = new Rect2i(r3.getX() + slotHeight.x() - 2, r3.getY() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
                    }
                }
            }
        }
        if (quickMoveGroup != TrinketsClient.quickMoveGroup && (quickMoveGroup = TrinketsClient.quickMoveGroup) != null) {
            int slotsWidth = handler.trinkets$getSlotWidth(quickMoveGroup) + 1;
            if (quickMoveGroup.getSlotId() == -1) {
                --slotsWidth;
            }
            Rect2i r4 = currentScreen.trinkets$getGroupRect(quickMoveGroup);
            quickMoveBounds = new Rect2i(0, 0, 0, 0);
            if (r4 != null) {
                Point slotHeight;
                int i;
                int l = (slotsWidth - 1) / 2 * 18;
                quickMoveBounds = new Rect2i(r4.getX() - l - 5, r4.getY() - 5, slotsWidth * 18 + 8, 26);
                if (TrinketsClient.quickMoveType != null && (i = handler.trinkets$getSlotTypes(quickMoveGroup).indexOf(TrinketsClient.quickMoveType)) >= 0 && (slotHeight = handler.trinkets$getSlotHeight(quickMoveGroup, i)) != null) {
                    int height = slotHeight.y();
                    quickMoveTypeBounds = new Rect2i(r4.getX() + slotHeight.x() - 2, r4.getY() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
                }
            }
        }
    }

    public static void tick() {
        if (TrinketsClient.quickMoveTimer > 0 && --TrinketsClient.quickMoveTimer <= 0) {
            TrinketsClient.quickMoveGroup = null;
        }
    }

    public static void drawGroup(GuiGraphics context, SlotGroup group, SlotType type) {
        TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
        RenderSystem.enableDepthTest();
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 305.0f);
        Rect2i r = currentScreen.trinkets$getGroupRect(group);
        int slotsWidth = handler.trinkets$getSlotWidth(group) + 1;
        List<Point> slotHeights = handler.trinkets$getSlotHeights(group);
        List<SlotType> slotTypes = handler.trinkets$getSlotTypes(group);
        if (group.getSlotId() == -1) {
            --slotsWidth;
        }
        int x = r.getX() - 4 - (slotsWidth - 1) / 2 * 18;
        int y = r.getY() - 4;
        if (slotsWidth > 1 || type != null) {
            Point slotHeight;
            int height;
            int s;
            context.blit(MORE_SLOTS, x, y, 0, 0, 4, 26);
            for (int i = 0; i < slotsWidth; ++i) {
                context.blit(MORE_SLOTS, x + i * 18 + 4, y, 4, 0, 18, 26);
            }
            context.blit(MORE_SLOTS, x + slotsWidth * 18 + 4, y, 22, 0, 4, 26);
            for (s = 0; s < slotHeights.size() && s < slotTypes.size(); ++s) {
                int i;
                if (slotTypes.get(s) != type || (height = (slotHeight = slotHeights.get(s)).y()) <= 1) continue;
                int top = (height - 1) / 2;
                int bottom = height / 2;
                int slotX = slotHeight.x() - 4 + r.getX();
                if (height > 2) {
                    context.blit(MORE_SLOTS, slotX, y - top * 18, 0, 0, 26, 4);
                }
                for (i = 1; i < top + 1; ++i) {
                    context.blit(MORE_SLOTS, slotX, y - i * 18 + 4, 0, 4, 26, 18);
                }
                for (i = 1; i < bottom + 1; ++i) {
                    context.blit(MORE_SLOTS, slotX, y + i * 18 + 4, 0, 4, 26, 18);
                }
                context.blit(MORE_SLOTS, slotX, y + 18 + bottom * 18 + 4, 0, 22, 26, 4);
            }
            for (s = 0; s < slotHeights.size(); ++s) {
                slotHeight = slotHeights.get(s);
                height = slotHeight.y();
                if (slotTypes.get(s) != type) {
                    height = 1;
                }
                int slotX = slotHeight.x() + r.getX() + 1;
                int top = (height - 1) / 2;
                int bottom = height / 2;
                context.blit(MORE_SLOTS, slotX, y - top * 18 + 1, 4, 1, 16, 3);
                context.blit(MORE_SLOTS, slotX, y + (bottom + 1) * 18 + 4, 4, 22, 16, 3);
            }
            if (group.getSlotId() != -1) {
                context.blit(MORE_SLOTS, r.getX() + 1, y + 1, 4, 1, 16, 3);
                context.blit(MORE_SLOTS, r.getX() + 1, y + 22, 4, 22, 16, 3);
            }
        } else {
            context.blit(MORE_SLOTS, x + 4, y + 4, 4, 4, 18, 18);
        }
        context.pose().popPose();
        RenderSystem.disableDepthTest();
    }

    public static void drawActiveGroup(GuiGraphics context) {
        if (TrinketsClient.activeGroup != null) {
            TrinketScreenManager.drawGroup(context, TrinketsClient.activeGroup, TrinketsClient.activeType);
        } else if (TrinketsClient.quickMoveGroup != null) {
            TrinketScreenManager.drawGroup(context, TrinketsClient.quickMoveGroup, TrinketsClient.quickMoveType);
        }
    }

    public static void drawExtraGroups(GuiGraphics context) {
        int i;
        TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
        int x = currentScreen.trinkets$getX();
        int y = currentScreen.trinkets$getY();
        int groupCount = handler.trinkets$getGroupCount();
        if (groupCount <= 0 || currentScreen.trinkets$isRecipeBookOpen()) {
            return;
        }
        int width = groupCount / 4;
        int height = groupCount % 4;
        if (height == 0) {
            height = 4;
            --width;
        }
        context.blit(MORE_SLOTS, x + 3, y, 7, 26, 1, 7);
        for (i = 0; i < width; ++i) {
            context.blit(MORE_SLOTS, x - 15 - 18 * i, y, 7, 26, 18, 7);
            context.blit(MORE_SLOTS, x - 15 - 18 * i, y + 79, 7, 51, 18, 7);
        }
        context.blit(MORE_SLOTS, x - 15 - 18 * width, y, 7, 26, 18, 7);
        context.blit(MORE_SLOTS, x - 15 - 18 * width, y + 7 + 18 * height, 7, 51, 18, 7);
        context.blit(MORE_SLOTS, x - 22 - 18 * width, y, 0, 26, 7, 7);
        context.blit(MORE_SLOTS, x - 22 - 18 * width, y + 7 + 18 * height, 0, 51, 7, 7);
        for (i = 0; i < height; ++i) {
            context.blit(MORE_SLOTS, x - 22 - 18 * width, y + 7 + 18 * i, 0, 34, 7, 18);
        }
        if (width > 0) {
            for (i = height; i < 4; ++i) {
                context.blit(MORE_SLOTS, x - 4 - 18 * width, y + 7 + 18 * i, 0, 34, 7, 18);
            }
        }
        if (width > 0 && height < 4) {
            context.blit(MORE_SLOTS, x - 4 - 18 * width, y + 79, 0, 51, 7, 7);
            context.blit(MORE_SLOTS, x - 4 - 18 * width, y + 7 + 18 * height, 0, 58, 7, 7);
        }
        if (width > 0 || height == 4) {
            context.blit(MORE_SLOTS, x, y + 79, 0, 58, 3, 7);
        }
    }

    public static boolean isClickInsideTrinketBounds(double mouseX, double mouseY) {
        int my;
        TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
        int x = currentScreen.trinkets$getX();
        int y = currentScreen.trinkets$getY();
        int mx = (int)(Math.round(mouseX) - (long)x);
        if (currentBounds.contains(mx, my = (int)(Math.round(mouseY) - (long)y))) {
            return true;
        }
        int groupCount = handler.trinkets$getGroupCount();
        if (groupCount <= 0 || currentScreen.trinkets$isRecipeBookOpen()) {
            return false;
        }
        int width = groupCount / 4;
        int height = groupCount % 4;
        if (width > 0 && new Rect2i(-4 - 18 * width, 0, 7 + 18 * width, 86).contains(mx, my)) {
            return true;
        }
        return height > 0 && new Rect2i(-22 - 18 * width, 0, 25, 14 + 18 * height).contains(mx, my);
    }

    static {
        currentBounds = new Rect2i(0, 0, 0, 0);
        typeBounds = new Rect2i(0, 0, 0, 0);
        quickMoveBounds = new Rect2i(0, 0, 0, 0);
        quickMoveTypeBounds = new Rect2i(0, 0, 0, 0);
        group = null;
        quickMoveGroup = null;
    }
}

