/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class TrinketsClient
implements ClientModInitializer {
    public static SlotGroup activeGroup;
    public static SlotType activeType;
    public static SlotGroup quickMoveGroup;
    public static SlotType quickMoveType;
    public static int quickMoveTimer;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.SYNC_INVENTORY, (payload, context) -> {
            Minecraft client = context.client();
            Entity entity = client.level.getEntity(payload.entityId());
            if (entity instanceof LivingEntity) {
                TrinketsApi.getTrinketComponent((LivingEntity)entity).ifPresent(trinkets -> {
                    InventoryMenu inventoryMenu;
                    String slot;
                    String group;
                    String[] split;
                    for (Map.Entry<String, CompoundTag> entry : payload.inventoryUpdates().entrySet()) {
                        TrinketInventory inv;
                        split = entry.getKey().split("/");
                        group = split[0];
                        slot = split[1];
                        Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
                        if (slots == null || (inv = slots.get(slot)) == null) continue;
                        inv.applySyncTag(entry.getValue());
                    }
                    if (entity instanceof Player && (inventoryMenu = ((Player)entity).inventoryMenu) instanceof TrinketPlayerScreenHandler) {
                        TrinketPlayerScreenHandler screenHandler = (TrinketPlayerScreenHandler)inventoryMenu;
                        screenHandler.trinkets$updateTrinketSlots(false);
                        if (TrinketScreenManager.currentScreen != null) {
                            TrinketScreenManager.currentScreen.trinkets$updateTrinketSlots();
                        }
                    }
                    for (Map.Entry<String, CompoundTag> entry : payload.contentUpdates().entrySet()) {
                        TrinketInventory inv;
                        split = entry.getKey().split("/");
                        group = split[0];
                        slot = split[1];
                        int index = Integer.parseInt(split[2]);
                        Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
                        if (slots == null || (inv = slots.get(slot)) == null || index >= inv.getContainerSize()) continue;
                        inv.setItem(index, (ItemStack)entry.getValue());
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.SYNC_SLOTS, (payload, context) -> {
            EntitySlotLoader.CLIENT.setSlots(payload.map());
            LocalPlayer player = context.player();
            if (player != null) {
                ((TrinketPlayerScreenHandler)player.inventoryMenu).trinkets$updateTrinketSlots(true);
                Minecraft client = context.client();
                Screen patt0$temp = client.screen;
                if (patt0$temp instanceof TrinketScreen) {
                    TrinketScreen trinketScreen = (TrinketScreen)patt0$temp;
                    trinketScreen.trinkets$updateTrinketSlots();
                }
                for (AbstractClientPlayer clientWorldPlayer : player.clientLevel.players()) {
                    ((TrinketPlayerScreenHandler)clientWorldPlayer.inventoryMenu).trinkets$updateTrinketSlots(true);
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.BREAK, (payload, context) -> {
            Minecraft client = context.client();
            Entity e = client.level.getEntity(payload.entityId());
            if (e instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)e;
                TrinketsApi.getTrinketComponent(entity).ifPresent(comp -> {
                    Map<String, TrinketInventory> groupMap = comp.getInventory().get(payload.group());
                    if (groupMap != null) {
                        TrinketInventory inv = groupMap.get(payload.slot());
                        if (payload.index() < inv.getContainerSize()) {
                            ItemStack stack = inv.getItem(payload.index());
                            SlotReference ref = new SlotReference(inv, payload.index());
                            Trinket trinket = TrinketsApi.getTrinket(stack.getItem());
                            trinket.onBreak(stack, ref, entity);
                        }
                    }
                });
            }
        });
    }
}

