/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.LivingEntityTrinketComponent;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import dev.emi.trinkets.payload.BreakPayload;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import dev.emi.trinkets.payload.SyncSlotsPayload;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;

public class TrinketsMain
implements ModInitializer,
EntityComponentInitializer {
    public static final String MOD_ID = "trinkets";
    public static final Logger LOGGER = LogManager.getLogger();

    public void onInitialize() {
        ResourceManagerHelper resourceManagerHelper = ResourceManagerHelper.get((PackType)PackType.SERVER_DATA);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)SlotLoader.INSTANCE);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)EntitySlotLoader.SERVER);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> EntitySlotLoader.SERVER.sync(server.getPlayerList().getPlayers()));
        UseItemCallback.EVENT.register((player, world, hand) -> {
            ItemStack stack = player.getItemInHand(hand);
            Trinket trinket = TrinketsApi.getTrinket(stack.getItem());
            if (trinket.canEquipFromUse(stack, (LivingEntity)player) && TrinketItem.equipItem(player, stack)) {
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        });
        Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"attribute_modifiers"), TrinketsAttributeModifiersComponent.TYPE);
        PayloadTypeRegistry.playS2C().register(TrinketsNetwork.BREAK, BreakPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TrinketsNetwork.SYNC_INVENTORY, SyncInventoryPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TrinketsNetwork.SYNC_SLOTS, SyncSlotsPayload.CODEC);
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, env) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MOD_ID).requires(source -> source.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"slot", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"offset", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)Commands.argument((String)"stack", (ArgumentType)ItemArgument.item((CommandBuildContext)registry)).executes(context -> {
            try {
                return TrinketsMain.trinketsCommand((CommandContext<CommandSourceStack>)context, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int amount = (Integer)context.getArgument("amount", Integer.class);
            return TrinketsMain.trinketsCommand((CommandContext<CommandSourceStack>)context, amount);
        })))))))).then(Commands.literal((String)"clear").executes(context -> {
            try {
                return TrinketsMain.clearCommand((CommandContext<CommandSourceStack>)context);
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }))));
    }

    private static int clearCommand(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            TrinketComponent comp = TrinketsApi.getTrinketComponent((LivingEntity)player).get();
            for (Map.Entry<String, Map<String, TrinketInventory>> entry : comp.getInventory().entrySet()) {
                for (TrinketInventory inv : entry.getValue().values()) {
                    inv.clearContent();
                }
            }
        }
        return 1;
    }

    private static int trinketsCommand(CommandContext<CommandSourceStack> context, int amount) {
        try {
            String group = (String)context.getArgument("group", String.class);
            String slot = (String)context.getArgument("slot", String.class);
            int offset = (Integer)context.getArgument("offset", Integer.class);
            ItemInput stack = (ItemInput)context.getArgument("stack", ItemInput.class);
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player != null) {
                TrinketComponent comp = TrinketsApi.getTrinketComponent((LivingEntity)player).get();
                SlotGroup slotGroup = comp.getGroups().getOrDefault(group, null);
                if (slotGroup != null) {
                    SlotType slotType = slotGroup.getSlots().getOrDefault(slot, null);
                    if (slotType != null) {
                        if (offset >= 0 && offset < slotType.getAmount()) {
                            comp.getInventory().get(group).get(slot).setItem(offset, stack.createItemStack(amount, true));
                            return 1;
                        }
                        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(offset + " offset does not exist for slot")));
                    } else {
                        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(slot + " does not exist")));
                    }
                } else {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(group + " does not exist")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(LivingEntity.class, TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new);
        registry.registerForPlayers(TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }
}

