/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.entity.RespawnableComponent;

public class LivingEntityTrinketComponent
implements TrinketComponent,
AutoSyncedComponent,
RespawnableComponent {
    public Map<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
    public Set<TrinketInventory> trackingUpdates = new HashSet<TrinketInventory>();
    public Map<String, SlotGroup> groups = new HashMap<String, SlotGroup>();
    public int size;
    public LivingEntity entity;
    private boolean syncing;

    public LivingEntityTrinketComponent(LivingEntity entity) {
        this.entity = entity;
        this.update();
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        return this.inventory;
    }

    @Override
    public void update() {
        Map<String, SlotGroup> entitySlots = TrinketsApi.getEntitySlots((Entity)this.entity);
        int count = 0;
        this.groups.clear();
        HashMap<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
        for (Map.Entry<String, SlotGroup> group : entitySlots.entrySet()) {
            String groupKey = group.getKey();
            SlotGroup groupValue = group.getValue();
            Map<String, TrinketInventory> oldGroup = this.inventory.get(groupKey);
            this.groups.put(groupKey, groupValue);
            for (Map.Entry<String, SlotType> slot : groupValue.getSlots().entrySet()) {
                TrinketInventory oldInv;
                TrinketInventory inv = new TrinketInventory(slot.getValue(), this, e -> this.trackingUpdates.add((TrinketInventory)e));
                if (oldGroup != null && (oldInv = oldGroup.get(slot.getKey())) != null) {
                    inv.copyFrom(oldInv);
                    for (int i = 0; i < oldInv.getContainerSize(); ++i) {
                        ItemStack stack = oldInv.getItem(i).copy();
                        if (i < inv.getContainerSize()) {
                            inv.setItem(i, stack);
                            continue;
                        }
                        LivingEntity livingEntity = this.entity;
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            player.getInventory().placeItemBackInInventory(stack);
                            continue;
                        }
                        this.entity.spawnAtLocation(stack);
                    }
                }
                inventory.computeIfAbsent(group.getKey(), k -> new HashMap()).put(slot.getKey(), inv);
                count += inv.getContainerSize();
            }
        }
        this.size = count;
        this.inventory = inventory;
    }

    @Override
    public void clearCachedModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearCachedModifiers();
            }
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return this.trackingUpdates;
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addModifier(modifier);
            }
        }
    }

    @Override
    public void addPersistentModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addPersistentModifier(modifier);
            }
        }
    }

    @Override
    public void removeModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.removeModifier(modifier.id());
            }
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                result.putAll((Object)(group.getKey() + "/" + slotType.getKey()), slotType.getValue().getModifiers().values());
            }
        }
        return result;
    }

    @Override
    public void clearModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearModifiers();
            }
        }
    }

    public void readFromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        NonNullList dropped = NonNullList.create();
        for (String groupKey : tag.getAllKeys()) {
            ListTag list;
            CompoundTag slotTag;
            CompoundTag groupTag = tag.getCompound(groupKey);
            if (groupTag == null) continue;
            Map<String, TrinketInventory> groupSlots = this.inventory.get(groupKey);
            if (groupSlots != null) {
                for (String slotKey : groupTag.getAllKeys()) {
                    slotTag = groupTag.getCompound(slotKey);
                    list = slotTag.getList("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.fromTag(slotTag.getCompound("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag c = list.getCompound(i);
                        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)c);
                        if (inv != null && i < inv.getContainerSize()) {
                            inv.setItem(i, stack);
                            continue;
                        }
                        dropped.add((Object)stack);
                    }
                }
                continue;
            }
            for (String slotKey : groupTag.getAllKeys()) {
                slotTag = groupTag.getCompound(slotKey);
                list = slotTag.getList("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag c = list.getCompound(i);
                    dropped.add((Object)ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)c));
                }
            }
        }
        for (ItemStack itemStack : dropped) {
            this.entity.spawnAtLocation(itemStack);
        }
        HashMultimap slotMap = HashMultimap.create();
        this.forEach((arg_0, arg_1) -> this.lambda$readFromNbt$2((Multimap)slotMap, arg_0, arg_1));
        for (Map.Entry<String, Map<String, TrinketInventory>> groupEntry : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotEntry : groupEntry.getValue().entrySet()) {
                String group = groupEntry.getKey();
                String slot = slotEntry.getKey();
                String key = group + "/" + slot;
                Collection modifiers = slotMap.get((Object)key);
                TrinketInventory inventory = slotEntry.getValue();
                for (AttributeModifier modifier : modifiers) {
                    inventory.removeCachedModifier(modifier);
                }
                inventory.clearCachedModifiers();
            }
        }
    }

    public void applySyncPacket(RegistryFriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag != null) {
            for (String groupKey : tag.getAllKeys()) {
                Map<String, TrinketInventory> groupSlots;
                CompoundTag groupTag = tag.getCompound(groupKey);
                if (groupTag == null || (groupSlots = this.inventory.get(groupKey)) == null) continue;
                for (String slotKey : groupTag.getAllKeys()) {
                    CompoundTag slotTag = groupTag.getCompound(slotKey);
                    ListTag list = slotTag.getList("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.applySyncTag(slotTag.getCompound("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag c = list.getCompound(i);
                        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)buf.registryAccess(), (CompoundTag)c);
                        if (inv == null || i >= inv.getContainerSize()) continue;
                        inv.setItem(i, stack);
                    }
                }
            }
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ((TrinketPlayerScreenHandler)player.inventoryMenu).trinkets$updateTrinketSlots(false);
            }
        }
    }

    public void writeToNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                CompoundTag slotTag = new CompoundTag();
                ListTag list = new ListTag();
                TrinketInventory inv = slot.getValue();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    CompoundTag c = (CompoundTag)inv.getItem(i).saveOptional(lookup);
                    list.add((Object)c);
                }
                slotTag.put("Metadata", (Tag)(this.syncing ? inv.getSyncTag() : inv.toTag()));
                slotTag.put("Items", (Tag)list);
                groupTag.put(slot.getKey(), (Tag)slotTag);
            }
            tag.put(group.getKey(), (Tag)groupTag);
        }
    }

    public void writeSyncPacket(RegistryFriendlyByteBuf buf, ServerPlayer recipient) {
        this.syncing = true;
        CompoundTag tag = new CompoundTag();
        this.writeToNbt(tag, (HolderLookup.Provider)buf.registryAccess());
        this.syncing = false;
        buf.writeNbt((Tag)tag);
    }

    public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory, boolean sameCharacter) {
        return lossless || keepInventory;
    }

    @Override
    public boolean isEquipped(Predicate<ItemStack> predicate) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    if (!predicate.test(inv.getItem(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<Tuple<SlotReference, ItemStack>> getEquipped(Predicate<ItemStack> predicate) {
        ArrayList<Tuple<SlotReference, ItemStack>> list = new ArrayList<Tuple<SlotReference, ItemStack>>();
        this.forEach((slotReference, itemStack) -> {
            if (predicate.test((ItemStack)itemStack)) {
                list.add(new Tuple(slotReference, itemStack));
            }
        });
        return list;
    }

    @Override
    public void forEach(BiConsumer<SlotReference, ItemStack> consumer) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    consumer.accept(new SlotReference(inv, i), inv.getItem(i));
                }
            }
        }
    }

    private /* synthetic */ void lambda$readFromNbt$2(Multimap slotMap, SlotReference ref, ItemStack stack) {
        if (!stack.isEmpty()) {
            Multimap<Holder<Attribute>, AttributeModifier> map = TrinketModifiers.get(stack, ref, this.entity);
            for (Holder entityAttribute : map.keySet()) {
                Object patt0$temp;
                if (!entityAttribute.isBound() || !((patt0$temp = entityAttribute.value()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)((Object)patt0$temp);
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

