/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class SlotAttributes {
    private static final Map<String, ResourceLocation> CACHED_IDS = Maps.newHashMap();
    private static final Map<String, Holder<Attribute>> CACHED_ATTRIBUTES = Maps.newHashMap();

    public static void addSlotModifier(Multimap<Holder<Attribute>, AttributeModifier> map, String slot, ResourceLocation identifier, double amount, AttributeModifier.Operation operation) {
        CACHED_ATTRIBUTES.putIfAbsent(slot, (Holder<Attribute>)Holder.direct((Object)((Object)new SlotEntityAttribute(slot))));
        map.put(CACHED_ATTRIBUTES.get(slot), (Object)new AttributeModifier(identifier, amount, operation));
    }

    public static ResourceLocation getIdentifier(SlotReference ref) {
        String key = ref.getId();
        return CACHED_IDS.computeIfAbsent(key, ResourceLocation::parse);
    }

    public static class SlotEntityAttribute
    extends Attribute {
        public String slot;

        private SlotEntityAttribute(String slot) {
            super("trinkets.slot." + slot.replace("/", "."), 0.0);
            this.slot = slot;
        }
    }
}

