/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import dev.emi.trinkets.api.SlotType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class SlotGroup {
    private final String name;
    private final int slotId;
    private final int order;
    private final Map<String, SlotType> slots;

    private SlotGroup(Builder builder) {
        this.name = builder.name;
        this.slots = builder.slots;
        this.slotId = builder.slotId;
        this.order = builder.order;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, SlotType> getSlots() {
        return ImmutableMap.copyOf(this.slots);
    }

    public void write(CompoundTag data) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Name", this.name);
        tag.putInt("SlotId", this.slotId);
        tag.putInt("Order", this.order);
        CompoundTag typesTag = new CompoundTag();
        this.slots.forEach((id, slot) -> {
            CompoundTag typeTag = new CompoundTag();
            slot.write(typeTag);
            typesTag.put(id, (Tag)typeTag);
        });
        tag.put("SlotTypes", (Tag)typesTag);
        data.put("GroupData", (Tag)tag);
    }

    public static SlotGroup read(CompoundTag data) {
        CompoundTag groupData = data.getCompound("GroupData");
        String name = groupData.getString("Name");
        int slotId = groupData.getInt("SlotId");
        int order = groupData.getInt("Order");
        CompoundTag typesTag = groupData.getCompound("SlotTypes");
        Builder builder = new Builder(name, slotId, order);
        for (String id : typesTag.getAllKeys()) {
            CompoundTag tag = (CompoundTag)typesTag.get(id);
            if (tag == null) continue;
            builder.addSlot(id, SlotType.read(tag));
        }
        return builder.build();
    }

    public static class Builder {
        private final String name;
        private final int slotId;
        private final int order;
        private final Map<String, SlotType> slots = new HashMap<String, SlotType>();

        public Builder(String name, int slotId, int order) {
            this.name = name;
            this.slotId = slotId;
            this.order = order;
        }

        public Builder addSlot(String name, SlotType slot) {
            this.slots.put(name, slot);
            return this;
        }

        public SlotGroup build() {
            return new SlotGroup(this);
        }
    }
}

