/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import dev.emi.trinkets.api.TrinketEnums;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SlotType {
    private final String group;
    private final String name;
    private final int order;
    private final int amount;
    private final ResourceLocation icon;
    private final Set<ResourceLocation> quickMovePredicates;
    private final Set<ResourceLocation> validatorPredicates;
    private final Set<ResourceLocation> tooltipPredicates;
    private final TrinketEnums.DropRule dropRule;

    public SlotType(String group, String name, int order, int amount, ResourceLocation icon, Set<ResourceLocation> quickMovePredicates, Set<ResourceLocation> validatorPredicates, Set<ResourceLocation> tooltipPredicates, TrinketEnums.DropRule dropRule) {
        this.group = group;
        this.name = name;
        this.order = order;
        this.amount = amount;
        this.icon = icon;
        this.quickMovePredicates = quickMovePredicates;
        this.validatorPredicates = validatorPredicates;
        this.tooltipPredicates = tooltipPredicates;
        this.dropRule = dropRule;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public int getAmount() {
        return this.amount;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public Set<ResourceLocation> getQuickMovePredicates() {
        return this.quickMovePredicates;
    }

    public Set<ResourceLocation> getValidatorPredicates() {
        return this.validatorPredicates;
    }

    public Set<ResourceLocation> getTooltipPredicates() {
        return this.tooltipPredicates;
    }

    public TrinketEnums.DropRule getDropRule() {
        return this.dropRule;
    }

    public MutableComponent getTranslation() {
        return Component.translatable((String)("trinkets.slot." + this.group + "." + this.name));
    }

    public void write(CompoundTag data) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Group", this.group);
        tag.putString("Name", this.name);
        tag.putInt("Order", this.order);
        tag.putInt("Amount", this.amount);
        tag.putString("Icon", this.icon.toString());
        ListTag quickMovePredicateList = new ListTag();
        for (ResourceLocation resourceLocation : this.quickMovePredicates) {
            quickMovePredicateList.add((Object)StringTag.valueOf((String)resourceLocation.toString()));
        }
        tag.put("QuickMovePredicates", (Tag)quickMovePredicateList);
        ListTag validatorPredicateList = new ListTag();
        for (ResourceLocation id : this.validatorPredicates) {
            validatorPredicateList.add((Object)StringTag.valueOf((String)id.toString()));
        }
        tag.put("ValidatorPredicates", (Tag)validatorPredicateList);
        ListTag listTag = new ListTag();
        for (ResourceLocation id : this.tooltipPredicates) {
            listTag.add((Object)StringTag.valueOf((String)id.toString()));
        }
        tag.put("TooltipPredicates", (Tag)listTag);
        tag.putString("DropRule", this.dropRule.toString());
        data.put("SlotData", (Tag)tag);
    }

    public static SlotType read(CompoundTag data) {
        CompoundTag slotData = data.getCompound("SlotData");
        String group = slotData.getString("Group");
        String name = slotData.getString("Name");
        int order = slotData.getInt("Order");
        int amount = slotData.getInt("Amount");
        ResourceLocation icon = ResourceLocation.parse((String)slotData.getString("Icon"));
        ListTag quickMoveList = slotData.getList("QuickMovePredicates", 8);
        HashSet<ResourceLocation> quickMovePredicates = new HashSet<ResourceLocation>();
        for (Tag tag : quickMoveList) {
            quickMovePredicates.add(ResourceLocation.parse((String)tag.getAsString()));
        }
        ListTag validatorList = slotData.getList("ValidatorPredicates", 8);
        HashSet<ResourceLocation> validatorPredicates = new HashSet<ResourceLocation>();
        for (Tag tag : validatorList) {
            validatorPredicates.add(ResourceLocation.parse((String)tag.getAsString()));
        }
        ListTag tooltipList = slotData.getList("TooltipPredicates", 8);
        HashSet<ResourceLocation> tooltipPredicates = new HashSet<ResourceLocation>();
        for (Tag tag : tooltipList) {
            tooltipPredicates.add(ResourceLocation.parse((String)tag.getAsString()));
        }
        String dropRuleName = slotData.getString("DropRule");
        TrinketEnums.DropRule dropRule = TrinketEnums.DropRule.DEFAULT;
        if (TrinketEnums.DropRule.has(dropRuleName)) {
            dropRule = TrinketEnums.DropRule.valueOf(dropRuleName);
        }
        return new SlotType(group, name, order, amount, icon, quickMovePredicates, validatorPredicates, tooltipPredicates, dropRule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotType slotType = (SlotType)o;
        return this.group.equals(slotType.group) && this.name.equals(slotType.name);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name);
    }

    public String getId() {
        return this.group + "/" + this.name;
    }
}

