/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.mixin.accessor.LivingEntityAccessor;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface Trinket {
    default public void tick(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public void onEquip(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public void onUnequip(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public boolean canEquip(ItemStack stack, SlotReference slot, LivingEntity entity) {
        return true;
    }

    default public boolean canUnequip(ItemStack stack, SlotReference slot, LivingEntity entity) {
        Player player;
        return !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || entity instanceof Player && (player = (Player)entity).isCreative();
    }

    default public boolean canEquipFromUse(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public Holder<SoundEvent> getEquipSound(ItemStack stack, SlotReference slot, LivingEntity entity) {
        Holder holder;
        Item item = stack.getItem();
        if (item instanceof Equipable) {
            Equipable eq = (Equipable)item;
            holder = eq.getEquipSound();
        } else {
            holder = null;
        }
        return holder;
    }

    default public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(ItemStack stack, SlotReference slot, LivingEntity entity, ResourceLocation slotIdentifier) {
        return Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    }

    default public void onBreak(ItemStack stack, SlotReference slot, LivingEntity entity) {
        ((LivingEntityAccessor)entity).invokePlayEquipmentBreakEffects(stack);
    }

    default public TrinketEnums.DropRule getDropRule(ItemStack stack, SlotReference slot, LivingEntity entity) {
        return TrinketEnums.DropRule.DEFAULT;
    }
}

