/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketInventory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.ladysnake.cca.api.v3.component.ComponentV3;

public interface TrinketComponent
extends ComponentV3 {
    public LivingEntity getEntity();

    public Map<String, SlotGroup> getGroups();

    public Map<String, Map<String, TrinketInventory>> getInventory();

    public void update();

    public void addTemporaryModifiers(Multimap<String, AttributeModifier> var1);

    public void addPersistentModifiers(Multimap<String, AttributeModifier> var1);

    public void removeModifiers(Multimap<String, AttributeModifier> var1);

    public void clearModifiers();

    public Multimap<String, AttributeModifier> getModifiers();

    public boolean isEquipped(Predicate<ItemStack> var1);

    default public boolean isEquipped(Item item) {
        return this.isEquipped((ItemStack stack) -> stack.getItem() == item);
    }

    public List<Tuple<SlotReference, ItemStack>> getEquipped(Predicate<ItemStack> var1);

    default public List<Tuple<SlotReference, ItemStack>> getEquipped(Item item) {
        return this.getEquipped((ItemStack stack) -> stack.getItem() == item);
    }

    default public List<Tuple<SlotReference, ItemStack>> getAllEquipped() {
        return this.getEquipped((ItemStack stack) -> !stack.isEmpty());
    }

    public void forEach(BiConsumer<SlotReference, ItemStack> var1);

    public Set<TrinketInventory> getTrackingUpdates();

    public void clearCachedModifiers();
}

