/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TrinketInventory
implements Container {
    private final SlotType slotType;
    private final int baseSize;
    private final TrinketComponent component;
    private final Map<ResourceLocation, AttributeModifier> modifiers = new HashMap<ResourceLocation, AttributeModifier>();
    private final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    private final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    private final Consumer<TrinketInventory> updateCallback;
    private NonNullList<ItemStack> stacks;
    private boolean update = false;

    public TrinketInventory(SlotType slotType, TrinketComponent comp, Consumer<TrinketInventory> updateCallback) {
        this.component = comp;
        this.slotType = slotType;
        this.baseSize = slotType.getAmount();
        this.stacks = NonNullList.withSize((int)this.baseSize, (Object)ItemStack.EMPTY);
        this.updateCallback = updateCallback;
    }

    public SlotType getSlotType() {
        return this.slotType;
    }

    public TrinketComponent getComponent() {
        return this.component;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.stacks.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public int getContainerSize() {
        this.update();
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        this.update();
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.stacks, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.stacks, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.update();
        this.stacks.set(slot, (Object)stack);
    }

    public void setChanged() {
    }

    public void markUpdate() {
        this.update = true;
        this.updateCallback.accept(this);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    public void addModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.id(), modifier);
        this.getModifiersByOperation(modifier.operation()).add(modifier);
        this.markUpdate();
    }

    public void addPersistentModifier(AttributeModifier modifier) {
        this.addModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    public void removeModifier(ResourceLocation identifier) {
        AttributeModifier modifier = this.modifiers.remove(identifier);
        if (modifier != null) {
            this.persistentModifiers.remove(modifier);
            this.getModifiersByOperation(modifier.operation()).remove(modifier);
            this.markUpdate();
        }
    }

    public void clearModifiers() {
        Iterator<ResourceLocation> iter = this.getModifiers().keySet().iterator();
        while (iter.hasNext()) {
            this.removeModifier(iter.next());
        }
    }

    public void removeCachedModifier(AttributeModifier attributeModifier) {
        this.cachedModifiers.remove(attributeModifier);
    }

    public void clearCachedModifiers() {
        for (AttributeModifier cachedModifier : this.cachedModifiers) {
            this.removeModifier(cachedModifier.id());
        }
        this.cachedModifiers.clear();
    }

    public void update() {
        if (this.update) {
            this.update = false;
            double baseSize = this.baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_VALUE)) {
                baseSize += mod.amount();
            }
            double size = baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                size += (double)this.baseSize * mod.amount();
            }
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                size *= mod.amount();
            }
            LivingEntity entity = this.component.getEntity();
            if (size != (double)this.getContainerSize()) {
                NonNullList newStacks = NonNullList.withSize((int)((int)size), (Object)ItemStack.EMPTY);
                for (int i = 0; i < this.stacks.size(); ++i) {
                    ItemStack stack = (ItemStack)this.stacks.get(i);
                    if (i < newStacks.size()) {
                        newStacks.set(i, (Object)stack);
                        continue;
                    }
                    entity.spawnAtLocation(stack);
                }
                this.stacks = newStacks;
            }
        }
    }

    public void copyFrom(TrinketInventory other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.forEach((uuid, modifier) -> this.addModifier((AttributeModifier)modifier));
        for (AttributeModifier persistentModifier : other.persistentModifiers) {
            this.addPersistentModifier(persistentModifier);
        }
        this.update();
    }

    public static void copyFrom(LivingEntity previous, LivingEntity current) {
        TrinketsApi.getTrinketComponent(previous).ifPresent(prevTrinkets -> TrinketsApi.getTrinketComponent(current).ifPresent(currentTrinkets -> {
            Map<String, Map<String, TrinketInventory>> prevMap = prevTrinkets.getInventory();
            Map<String, Map<String, TrinketInventory>> currentMap = currentTrinkets.getInventory();
            for (Map.Entry<String, Map<String, TrinketInventory>> entry : prevMap.entrySet()) {
                Map<String, TrinketInventory> currentInvs = currentMap.get(entry.getKey());
                if (currentInvs == null) continue;
                for (Map.Entry<String, TrinketInventory> invEntry : entry.getValue().entrySet()) {
                    TrinketInventory currentInv = currentInvs.get(invEntry.getKey());
                    if (currentInv == null) continue;
                    currentInv.copyFrom(invEntry.getValue());
                }
            }
        }));
    }

    public CompoundTag toTag() {
        ListTag NbtList;
        CompoundTag NbtCompound = new CompoundTag();
        if (!this.persistentModifiers.isEmpty()) {
            NbtList = new ListTag();
            for (AttributeModifier entityAttributeModifier : this.persistentModifiers) {
                NbtList.add((Object)entityAttributeModifier.save());
            }
            NbtCompound.put("PersistentModifiers", (Tag)NbtList);
        }
        if (!this.modifiers.isEmpty()) {
            NbtList = new ListTag();
            this.modifiers.forEach((uuid, modifier) -> {
                if (!this.persistentModifiers.contains(modifier)) {
                    NbtList.add((Object)modifier.save());
                }
            });
            NbtCompound.put("CachedModifiers", (Tag)NbtList);
        }
        return NbtCompound;
    }

    public void fromTag(CompoundTag tag) {
        AttributeModifier entityAttributeModifier;
        int i;
        ListTag NbtList;
        if (tag.contains("PersistentModifiers", 9)) {
            NbtList = tag.getList("PersistentModifiers", 10);
            for (i = 0; i < NbtList.size(); ++i) {
                entityAttributeModifier = AttributeModifier.load((CompoundTag)NbtList.getCompound(i));
                if (entityAttributeModifier == null) continue;
                this.addPersistentModifier(entityAttributeModifier);
            }
        }
        if (tag.contains("CachedModifiers", 9)) {
            NbtList = tag.getList("CachedModifiers", 10);
            for (i = 0; i < NbtList.size(); ++i) {
                entityAttributeModifier = AttributeModifier.load((CompoundTag)NbtList.getCompound(i));
                if (entityAttributeModifier == null) continue;
                this.cachedModifiers.add(entityAttributeModifier);
                this.addModifier(entityAttributeModifier);
            }
            this.update();
        }
    }

    public CompoundTag getSyncTag() {
        CompoundTag NbtCompound = new CompoundTag();
        if (!this.modifiers.isEmpty()) {
            ListTag NbtList = new ListTag();
            for (Map.Entry<ResourceLocation, AttributeModifier> modifier : this.modifiers.entrySet()) {
                NbtList.add((Object)modifier.getValue().save());
            }
            NbtCompound.put("Modifiers", (Tag)NbtList);
        }
        return NbtCompound;
    }

    public void applySyncTag(CompoundTag tag) {
        this.modifiers.clear();
        this.persistentModifiers.clear();
        this.modifiersByOperation.clear();
        if (tag.contains("Modifiers", 9)) {
            ListTag NbtList = tag.getList("Modifiers", 10);
            for (int i = 0; i < NbtList.size(); ++i) {
                AttributeModifier entityAttributeModifier = AttributeModifier.load((CompoundTag)NbtList.getCompound(i));
                if (entityAttributeModifier == null) continue;
                this.addModifier(entityAttributeModifier);
            }
        }
        this.markUpdate();
        this.update();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinketInventory that = (TrinketInventory)o;
        return this.slotType.equals(that.slotType);
    }

    public int hashCode() {
        return Objects.hash(this.slotType);
    }
}

