/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class TrinketItem
extends Item
implements Trinket {
    public TrinketItem(Item.Properties settings) {
        super(settings);
        TrinketsApi.registerTrinket(this, this);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (TrinketItem.equipItem(user, stack)) {
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return super.use(world, user, hand);
    }

    public static boolean equipItem(Player user, ItemStack stack) {
        return TrinketItem.equipItem((LivingEntity)user, stack);
    }

    public static boolean equipItem(LivingEntity user, ItemStack stack) {
        Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(user);
        if (optional.isPresent()) {
            TrinketComponent comp = optional.get();
            for (Map<String, TrinketInventory> group : comp.getInventory().values()) {
                for (TrinketInventory inv : group.values()) {
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        SlotReference ref;
                        if (!inv.getItem(i).isEmpty() || !TrinketSlot.canInsert(stack, ref = new SlotReference(inv, i), user)) continue;
                        ItemStack newStack = stack.copy();
                        inv.setItem(i, newStack);
                        Trinket trinket = TrinketsApi.getTrinket(stack.getItem());
                        Holder<SoundEvent> soundEvent = trinket.getEquipSound(stack, ref, user);
                        if (!stack.isEmpty() && soundEvent != null) {
                            user.gameEvent((Holder)GameEvent.EQUIP);
                            user.playSound((SoundEvent)soundEvent.value(), 1.0f, 1.0f);
                        }
                        stack.setCount(0);
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

