/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function3;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.payload.BreakPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistryV3;

public class TrinketsApi {
    public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"trinkets"), TrinketComponent.class);
    private static final Map<ResourceLocation, Function3<ItemStack, SlotReference, LivingEntity, TriState>> PREDICATES = new HashMap<ResourceLocation, Function3<ItemStack, SlotReference, LivingEntity, TriState>>();
    private static final Map<Item, Trinket> TRINKETS = new HashMap<Item, Trinket>();
    private static final Trinket DEFAULT_TRINKET;

    public static void registerTrinket(Item item, Trinket trinket) {
        TRINKETS.put(item, trinket);
    }

    public static Trinket getTrinket(Item item) {
        return TRINKETS.getOrDefault(item, DEFAULT_TRINKET);
    }

    public static Trinket getDefaultTrinket() {
        return DEFAULT_TRINKET;
    }

    public static Optional<TrinketComponent> getTrinketComponent(LivingEntity livingEntity) {
        return TRINKET_COMPONENT.maybeGet((Object)livingEntity);
    }

    public static void onTrinketBroken(ItemStack stack, SlotReference ref, LivingEntity entity) {
        Level world = entity.level();
        if (!world.isClientSide) {
            BreakPayload packet = new BreakPayload(entity.getId(), ref.inventory().getSlotType().getGroup(), ref.inventory().getSlotType().getName(), ref.index());
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)packet);
            }
            PlayerLookup.tracking((Entity)entity).forEach(watcher -> ServerPlayNetworking.send((ServerPlayer)watcher, (CustomPacketPayload)packet));
        }
    }

    @Deprecated
    public static Map<String, SlotGroup> getPlayerSlots() {
        return TrinketsApi.getEntitySlots(EntityType.PLAYER);
    }

    public static Map<String, SlotGroup> getPlayerSlots(Level world) {
        return TrinketsApi.getEntitySlots(world, EntityType.PLAYER);
    }

    public static Map<String, SlotGroup> getPlayerSlots(Player player) {
        return TrinketsApi.getEntitySlots((Entity)player);
    }

    @Deprecated
    public static Map<String, SlotGroup> getEntitySlots(EntityType<?> type) {
        EntitySlotLoader loader = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(Level world, EntityType<?> type) {
        EntitySlotLoader loader = world.isClientSide() ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(Entity entity) {
        if (entity != null) {
            return TrinketsApi.getEntitySlots(entity.level(), entity.getType());
        }
        return ImmutableMap.of();
    }

    public static void registerTrinketPredicate(ResourceLocation id, Function3<ItemStack, SlotReference, LivingEntity, TriState> predicate) {
        PREDICATES.put(id, predicate);
    }

    public static Optional<Function3<ItemStack, SlotReference, LivingEntity, TriState>> getTrinketPredicate(ResourceLocation id) {
        return Optional.ofNullable(PREDICATES.get(id));
    }

    public static boolean evaluatePredicateSet(Set<ResourceLocation> set, ItemStack stack, SlotReference ref, LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        for (ResourceLocation id : set) {
            Optional<Function3<ItemStack, SlotReference, LivingEntity, TriState>> function = TrinketsApi.getTrinketPredicate(id);
            if (function.isPresent()) {
                state = (TriState)function.get().apply((Object)stack, (Object)ref, (Object)entity);
            }
            if (state == TriState.DEFAULT) continue;
            break;
        }
        return state.get();
    }

    public static Enchantment.EnchantmentDefinition withTrinketSlots(Enchantment.EnchantmentDefinition definition, Set<String> slots) {
        Enchantment.EnchantmentDefinition def = new Enchantment.EnchantmentDefinition(definition.supportedItems(), definition.primaryItems(), definition.weight(), definition.maxLevel(), definition.minCost(), definition.maxCost(), definition.anvilCost(), definition.slots());
        ((TrinketSlotTarget)def).trinkets$slots(slots);
        return def;
    }

    static {
        TrinketsApi.registerTrinketPredicate(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"all"), (Function3<ItemStack, SlotReference, LivingEntity, TriState>)((Function3)(stack, ref, entity) -> TriState.TRUE));
        TrinketsApi.registerTrinketPredicate(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"none"), (Function3<ItemStack, SlotReference, LivingEntity, TriState>)((Function3)(stack, ref, entity) -> TriState.FALSE));
        TagKey trinketsAll = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"all"));
        TrinketsApi.registerTrinketPredicate(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"tag"), (Function3<ItemStack, SlotReference, LivingEntity, TriState>)((Function3)(stack, ref, entity) -> {
            SlotType slot = ref.inventory().getSlotType();
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)slot.getId()));
            if (stack.is(tag) || stack.is(trinketsAll)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        TrinketsApi.registerTrinketPredicate(ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"relevant"), (Function3<ItemStack, SlotReference, LivingEntity, TriState>)((Function3)(stack, ref, entity) -> {
            Multimap<Holder<Attribute>, AttributeModifier> map = TrinketModifiers.get(stack, ref, entity);
            if (!map.isEmpty()) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        DEFAULT_TRINKET = new Trinket(){};
    }
}

