/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record TrinketsAttributeModifiersComponent(List<Entry> modifiers, boolean showInTooltip) {
    public static final TrinketsAttributeModifiersComponent DEFAULT = new TrinketsAttributeModifiersComponent(List.of(), true);
    private static final Codec<TrinketsAttributeModifiersComponent> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(TrinketsAttributeModifiersComponent::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(TrinketsAttributeModifiersComponent::showInTooltip)).apply((Applicative)instance, TrinketsAttributeModifiersComponent::new));
    public static final Codec<TrinketsAttributeModifiersComponent> CODEC = Codec.withAlternative(BASE_CODEC, (Codec)Entry.CODEC.listOf(), attributeModifiers -> new TrinketsAttributeModifiersComponent((List<Entry>)attributeModifiers, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrinketsAttributeModifiersComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)Entry.PACKET_CODEC.apply(ByteBufCodecs.list()), TrinketsAttributeModifiersComponent::modifiers, (StreamCodec)ByteBufCodecs.BOOL, TrinketsAttributeModifiersComponent::showInTooltip, TrinketsAttributeModifiersComponent::new);
    public static final DataComponentType<TrinketsAttributeModifiersComponent> TYPE = DataComponentType.builder().persistent(CODEC).networkSynchronized(PACKET_CODEC).build();

    public TrinketsAttributeModifiersComponent withShowInTooltip(boolean showInTooltip) {
        return new TrinketsAttributeModifiersComponent(this.modifiers, showInTooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier) {
            return this.add(attribute, modifier, Optional.empty());
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier, String slot) {
            return this.add(attribute, modifier, Optional.of(slot));
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier, Optional<String> slot) {
            this.entries.add((Object)new Entry(attribute, modifier, slot));
            return this;
        }

        public TrinketsAttributeModifiersComponent build() {
            return new TrinketsAttributeModifiersComponent((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, Optional<String> slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)Codec.STRING.optionalFieldOf("slot").forGetter(Entry::slot)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ATTRIBUTE), Entry::attribute, (StreamCodec)AttributeModifier.STREAM_CODEC, Entry::modifier, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), Entry::slot, Entry::new);
    }
}

