/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.emi.trinkets.api.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface TrinketRenderer {
    public void render(ItemStack var1, SlotReference var2, EntityModel<? extends LivingEntity> var3, PoseStack var4, MultiBufferSource var5, int var6, LivingEntity var7, float var8, float var9, float var10, float var11, float var12, float var13);

    public static void followBodyRotations(LivingEntity entity, HumanoidModel<LivingEntity> model) {
        LivingEntityRenderer livingRenderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (render instanceof LivingEntityRenderer && (entityModel = (livingRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            HumanoidModel bipedModel = (HumanoidModel)entityModel;
            bipedModel.copyPropertiesTo(model);
        }
    }

    public static void translateToFace(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player, float headYaw, float headPitch) {
        if (player.isVisuallySwimming() || player.isFallFlying()) {
            matrices.mulPose(Axis.ZP.rotationDegrees(model.head.zRot));
            matrices.mulPose(Axis.YP.rotationDegrees(headYaw));
            matrices.mulPose(Axis.XP.rotationDegrees(-45.0f));
        } else {
            if (player.isCrouching() && !model.riding) {
                matrices.translate(0.0f, 0.25f, 0.0f);
            }
            matrices.mulPose(Axis.YP.rotationDegrees(headYaw));
            matrices.mulPose(Axis.XP.rotationDegrees(headPitch));
        }
        matrices.translate(0.0f, -0.25f, -0.3f);
    }

    public static void translateToChest(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player) {
        if (player.isCrouching() && !model.riding && !player.isSwimming()) {
            matrices.translate(0.0f, 0.2f, 0.0f);
            matrices.mulPose(Axis.XP.rotation(model.body.xRot));
        }
        matrices.mulPose(Axis.YP.rotation(model.body.yRot));
        matrices.translate(0.0f, 0.4f, -0.16f);
    }

    public static void translateToRightArm(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player) {
        if (player.isCrouching() && !model.riding && !player.isSwimming()) {
            matrices.translate(0.0f, 0.2f, 0.0f);
        }
        matrices.mulPose(Axis.YP.rotation(model.body.yRot));
        matrices.translate(-0.3125f, 0.15625f, 0.0f);
        matrices.mulPose(Axis.ZP.rotation(model.rightArm.zRot));
        matrices.mulPose(Axis.YP.rotation(model.rightArm.yRot));
        matrices.mulPose(Axis.XP.rotation(model.rightArm.xRot));
        matrices.translate(-0.0625f, 0.625f, 0.0f);
    }

    public static void translateToLeftArm(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player) {
        if (player.isCrouching() && !model.riding && !player.isSwimming()) {
            matrices.translate(0.0f, 0.2f, 0.0f);
        }
        matrices.mulPose(Axis.YP.rotation(model.body.yRot));
        matrices.translate(0.3125f, 0.15625f, 0.0f);
        matrices.mulPose(Axis.ZP.rotation(model.leftArm.zRot));
        matrices.mulPose(Axis.YP.rotation(model.leftArm.yRot));
        matrices.mulPose(Axis.XP.rotation(model.leftArm.xRot));
        matrices.translate(0.0625f, 0.625f, 0.0f);
    }

    public static void translateToRightLeg(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player) {
        if (player.isCrouching() && !model.riding && !player.isSwimming()) {
            matrices.translate(0.0f, 0.0f, 0.25f);
        }
        matrices.translate(-0.125f, 0.75f, 0.0f);
        matrices.mulPose(Axis.ZP.rotation(model.rightLeg.zRot));
        matrices.mulPose(Axis.YP.rotation(model.rightLeg.yRot));
        matrices.mulPose(Axis.XP.rotation(model.rightLeg.xRot));
        matrices.translate(0.0f, 0.75f, 0.0f);
    }

    public static void translateToLeftLeg(PoseStack matrices, PlayerModel<AbstractClientPlayer> model, AbstractClientPlayer player) {
        if (player.isCrouching() && !model.riding && !player.isSwimming()) {
            matrices.translate(0.0f, 0.0f, 0.25f);
        }
        matrices.translate(0.125f, 0.75f, 0.0f);
        matrices.mulPose(Axis.ZP.rotation(model.leftLeg.zRot));
        matrices.mulPose(Axis.YP.rotation(model.leftLeg.yRot));
        matrices.mulPose(Axis.XP.rotation(model.leftLeg.xRot));
        matrices.translate(0.0f, 0.75f, 0.0f);
    }
}

