/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.data.SlotLoader;
import dev.emi.trinkets.payload.SyncSlotsPayload;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class EntitySlotLoader
extends SimplePreparableReloadListener<Map<String, Map<String, Set<String>>>>
implements IdentifiableResourceReloadListener {
    public static final EntitySlotLoader CLIENT = new EntitySlotLoader();
    public static final EntitySlotLoader SERVER = new EntitySlotLoader();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"entities");
    private final Map<EntityType<?>, Map<String, SlotGroup>> slots = new HashMap();

    protected Map<String, Map<String, Set<String>>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>();
        String dataType = "entities";
        for (Map.Entry entry : resourceManager.listResourceStacks(dataType, id -> id.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            if (!identifier.getNamespace().equals("trinkets")) continue;
            try {
                for (Resource resource : (List)entry.getValue()) {
                    InputStreamReader reader = new InputStreamReader(resource.open());
                    JsonObject jsonObject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    try {
                        boolean replace = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"replace", (boolean)false);
                        JsonArray assignedSlots = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"slots", (JsonArray)new JsonArray());
                        HashMap<String, Set> groups = new HashMap<String, Set>();
                        if (assignedSlots != null) {
                            for (JsonElement assignedSlot : assignedSlots) {
                                String slot = assignedSlot.getAsString();
                                String[] parsedSlot = slot.split("/");
                                if (parsedSlot.length != 2) {
                                    TrinketsMain.LOGGER.error("Detected malformed slot assignment " + slot + "! Slots should be in the format 'group/slot'.");
                                    continue;
                                }
                                String group = parsedSlot[0];
                                String name = parsedSlot[1];
                                groups.computeIfAbsent(group, k -> new HashSet()).add(name);
                            }
                        }
                        JsonArray entities = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"entities", (JsonArray)new JsonArray());
                        if (groups.isEmpty() || entities == null) continue;
                        for (JsonElement entity : entities) {
                            String name = entity.getAsString();
                            Object id2 = name.startsWith("#") ? "#" + String.valueOf(ResourceLocation.parse((String)name.substring(1))) : ResourceLocation.parse((String)name).toString();
                            Map slots = map.computeIfAbsent((String)id2, k -> new HashMap());
                            if (replace) {
                                slots.clear();
                            }
                            groups.forEach((groupName, slotNames) -> slots.computeIfAbsent(groupName, k -> new HashSet()).addAll(slotNames));
                        }
                    }
                    catch (JsonSyntaxException e) {
                        TrinketsMain.LOGGER.error("[trinkets] Syntax error while reading data for " + identifier.getPath());
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                TrinketsMain.LOGGER.error("[trinkets] Unknown IO error while reading slot data!");
                e.printStackTrace();
            }
        }
        return map;
    }

    protected void apply(Map<String, Map<String, Set<String>>> loader, ResourceManager manager, ProfilerFiller profiler) {
        Map<String, SlotLoader.GroupData> slots = SlotLoader.INSTANCE.getSlots();
        HashMap<EntityType, Map> groupBuilders = new HashMap<EntityType, Map>();
        loader.forEach((entityName, groups) -> {
            HashSet<EntityType> types = new HashSet<EntityType>();
            try {
                if (entityName.startsWith("#")) {
                    TrinketsMain.LOGGER.error("[trinkets] Attempted to assign entity entry to tag");
                } else {
                    types.add((EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entityName)).orElseThrow(() -> new IllegalArgumentException("Unknown entity '" + entityName + "'")));
                }
            }
            catch (IllegalArgumentException e) {
                TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown entity entry " + entityName);
            }
            for (EntityType type : types) {
                Map builders = groupBuilders.computeIfAbsent(type, k -> new HashMap());
                groups.forEach((groupName, slotNames) -> {
                    SlotLoader.GroupData group = (SlotLoader.GroupData)slots.get(groupName);
                    if (group != null) {
                        SlotGroup.Builder builder = builders.computeIfAbsent(groupName, k -> new SlotGroup.Builder((String)groupName, group.getSlotId(), group.getOrder()));
                        slotNames.forEach(slotName -> {
                            SlotLoader.SlotData slotData = group.getSlot((String)slotName);
                            if (slotData != null) {
                                builder.addSlot((String)slotName, slotData.create((String)groupName, (String)slotName));
                            } else {
                                TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown slot " + slotName);
                            }
                        });
                    } else {
                        TrinketsMain.LOGGER.error("[trinkets] Attempted to assign slot from unknown group " + groupName);
                    }
                });
            }
        });
        this.slots.clear();
        groupBuilders.forEach((entity, groups) -> {
            Map entitySlots = this.slots.computeIfAbsent((EntityType<?>)entity, k -> new HashMap());
            groups.forEach((groupName, groupBuilder) -> entitySlots.putIfAbsent(groupName, groupBuilder.build()));
        });
    }

    public Map<String, SlotGroup> getEntitySlots(EntityType<?> entityType) {
        if (this.slots.containsKey(entityType)) {
            return ImmutableMap.copyOf(this.slots.get(entityType));
        }
        return ImmutableMap.of();
    }

    public void setSlots(Map<EntityType<?>, Map<String, SlotGroup>> slots) {
        this.slots.clear();
        this.slots.putAll(slots);
    }

    public void sync(ServerPlayer playerEntity) {
        ServerPlayNetworking.send((ServerPlayer)playerEntity, (CustomPacketPayload)new SyncSlotsPayload(Map.copyOf(this.slots)));
    }

    public void sync(List<? extends ServerPlayer> players) {
        SyncSlotsPayload packet = new SyncSlotsPayload(Map.copyOf(this.slots));
        players.forEach(player -> ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)packet));
        players.forEach(player -> ((TrinketPlayerScreenHandler)player.inventoryMenu).trinkets$updateTrinketSlots(true));
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return Lists.newArrayList((Object[])new ResourceLocation[]{SlotLoader.ID, ResourceReloadListenerKeys.TAGS});
    }
}

