/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.CreativeTrinketSlot;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.SurvivalTrinketSlot;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements TrinketScreen {
    @Shadow
    private static CreativeModeTab selectedTab;

    @Shadow
    protected abstract void selectTab(CreativeModeTab var1);

    private CreativeInventoryScreenMixin() {
        super(null, null, null);
    }

    @Redirect(at=@At(value="INVOKE", target="net/minecraft/util/collection/DefaultedList.size()I"), method={"setSelectedTab"})
    private int size(NonNullList<ItemStack> list) {
        return 46;
    }

    @Inject(at={@At(value="HEAD")}, method={"setSelectedTab"})
    private void setSelectedTab(CreativeModeTab g, CallbackInfo info) {
        if (g.getType() != CreativeModeTab.Type.INVENTORY) {
            TrinketScreenManager.removeSelections();
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/screen/slot/Slot.<init>(Lnet/minecraft/inventory/Inventory;III)V")}, method={"setSelectedTab"})
    private void addCreativeTrinketSlots(CreativeModeTab g, CallbackInfo info) {
        TrinketPlayerScreenHandler handler = this.trinkets$getHandler();
        for (int i = handler.trinkets$getTrinketSlotStart(); i < handler.trinkets$getTrinketSlotEnd(); ++i) {
            Slot slot = (Slot)this.minecraft.player.inventoryMenu.slots.get(i);
            if (!(slot instanceof SurvivalTrinketSlot)) continue;
            SurvivalTrinketSlot ts = (SurvivalTrinketSlot)slot;
            SlotGroup group = TrinketsApi.getPlayerSlots((Player)this.minecraft.player).get(ts.getType().getGroup());
            Rect2i rect = this.trinkets$getGroupRect(group);
            Point pos = this.trinkets$getHandler().trinkets$getGroupPos(group);
            if (pos == null) {
                return;
            }
            int xOff = rect.getX() + 1 - pos.x();
            int yOff = rect.getY() + 1 - pos.y();
            ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).slots.add((Object)new CreativeTrinketSlot(ts, ts.getContainerSlot(), ts.x + xOff, ts.y + yOff));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"init"})
    private void init(CallbackInfo info) {
        TrinketScreenManager.init(this);
    }

    @Inject(at={@At(value="HEAD")}, method={"removed"})
    private void removed(CallbackInfo info) {
        TrinketScreenManager.removeSelections();
    }

    @Inject(at={@At(value="TAIL")}, method={"handledScreenTick"})
    private void tick(CallbackInfo info) {
        TrinketScreenManager.tick();
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            TrinketScreenManager.update(mouseX, mouseY);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"drawBackground"})
    private void drawBackground(GuiGraphics context, float delta, int mouseX, int mouseY, CallbackInfo info) {
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            TrinketScreenManager.drawExtraGroups(context);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"drawForeground"})
    private void drawForeground(GuiGraphics context, int mouseX, int mouseY, CallbackInfo info) {
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            TrinketScreenManager.drawActiveGroup(context);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isClickOutsideBounds"}, cancellable=true)
    private void isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button, CallbackInfoReturnable<Boolean> info) {
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY && TrinketScreenManager.isClickInsideTrinketBounds(mouseX, mouseY)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isClickInTab"}, cancellable=true)
    private void isClickInTab(CreativeModeTab group, double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
        if (TrinketsClient.activeGroup != null) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderTabTooltipIfHovered"}, cancellable=true)
    private void renderTabTooltipIfHovered(GuiGraphics context, CreativeModeTab group, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> info) {
        if (TrinketsClient.activeGroup != null) {
            info.setReturnValue((Object)false);
        }
    }

    @Override
    public TrinketPlayerScreenHandler trinkets$getHandler() {
        return (TrinketPlayerScreenHandler)this.minecraft.player.inventoryMenu;
    }

    @Override
    public Rect2i trinkets$getGroupRect(SlotGroup group) {
        int groupNum = this.trinkets$getHandler().trinkets$getGroupNum(group);
        if (groupNum <= 3) {
            return switch (groupNum) {
                case 1 -> new Rect2i(15, 19, 17, 17);
                case 2 -> new Rect2i(126, 19, 17, 17);
                case 3 -> new Rect2i(145, 19, 17, 17);
                case -5 -> new Rect2i(53, 5, 17, 17);
                case -6 -> new Rect2i(53, 32, 17, 17);
                case -7 -> new Rect2i(107, 5, 17, 17);
                case -8 -> new Rect2i(107, 32, 17, 17);
                case -45 -> new Rect2i(34, 19, 17, 17);
                default -> new Rect2i(0, 0, 0, 0);
            };
        }
        Point pos = this.trinkets$getHandler().trinkets$getGroupPos(group);
        if (pos != null) {
            return new Rect2i(pos.x() - 1, pos.y() - 1, 17, 17);
        }
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public Slot trinkets$getFocusedSlot() {
        return this.hoveredSlot;
    }

    @Override
    public int trinkets$getX() {
        return this.leftPos;
    }

    @Override
    public int trinkets$getY() {
        return this.topPos;
    }

    @Override
    public boolean trinkets$isRecipeBookOpen() {
        return false;
    }

    @Override
    public void trinkets$updateTrinketSlots() {
        this.selectTab(selectedTab);
    }
}

