/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(at={@At(value="TAIL")}, method={"forEachEnchantment(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/enchantment/EnchantmentHelper$ContextAwareConsumer;)V"})
    private static void forEachTrinket(LivingEntity entity, EnchantmentHelper.EnchantmentInSlotVisitor contextAwareConsumer, CallbackInfo info) {
        Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(entity);
        if (optional.isPresent()) {
            TrinketComponent comp = optional.get();
            comp.forEach((ref, stack) -> {
                ItemEnchantments enchantments;
                if (!stack.isEmpty() && (enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null && !enchantments.isEmpty()) {
                    EnchantedItemInUse context = new EnchantedItemInUse(stack, null, entity, item -> TrinketsApi.onTrinketBroken(stack, ref, entity));
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        Holder registryEntry = (Holder)entry.getKey();
                        List slots = ((Enchantment)registryEntry.value()).definition().slots();
                        Set<String> trinketSlots = ((TrinketSlotTarget)((Enchantment)registryEntry.value()).definition()).trinkets$slots();
                        if (!slots.contains(EquipmentSlotGroup.ANY) && !slots.contains(EquipmentSlotGroup.ARMOR) && !trinketSlots.contains(ref.inventory().getSlotType().getId())) continue;
                        contextAwareConsumer.accept(registryEntry, entry.getIntValue(), context);
                    }
                }
            });
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/EquipmentSlot;values()[Lnet/minecraft/entity/EquipmentSlot;")}, method={"chooseEquipmentWith"})
    private static void addTrinketsAsChoices(DataComponentType<?> componentType, LivingEntity entity, Predicate<ItemStack> stackPredicate, CallbackInfoReturnable<Optional<EnchantedItemInUse>> info, @Local List<EnchantedItemInUse> list) {
        Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(entity);
        if (optional.isPresent()) {
            TrinketComponent comp = optional.get();
            comp.forEach((ref, stack) -> {
                if (stackPredicate.test((ItemStack)stack)) {
                    ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        Holder registryEntry = (Holder)entry.getKey();
                        List slots = ((Enchantment)registryEntry.value()).definition().slots();
                        Set<String> trinketSlots = ((TrinketSlotTarget)((Enchantment)registryEntry.value()).definition()).trinkets$slots();
                        if (!((Enchantment)registryEntry.value()).effects().has(componentType) || !slots.contains(EquipmentSlotGroup.ANY) && !slots.contains(EquipmentSlotGroup.ARMOR) && !trinketSlots.contains(ref.inventory().getSlotType().getId())) continue;
                        list.add(new EnchantedItemInUse(stack, null, entity, item -> TrinketsApi.onTrinketBroken(stack, ref, entity)));
                    }
                }
            });
        }
    }
}

