/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.mixin.accessor.CreativeSlotAccessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin
extends Screen {
    @Unique
    private static final ResourceLocation MORE_SLOTS = ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"textures/gui/more_slots.png");
    @Unique
    private static final ResourceLocation BLANK_BACK = ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"textures/gui/blank_back.png");

    private HandledScreenMixin() {
        super(null);
    }

    @Inject(at={@At(value="HEAD")}, method={"removed"})
    private void removed(CallbackInfo info) {
        if (this instanceof InventoryScreen) {
            TrinketScreenManager.removeSelections();
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/client/util/math/MatrixStack.translate(FFF)V")}, method={"drawSlot"})
    private void changeZ(GuiGraphics context, Slot slot, CallbackInfo info) {
        if (slot instanceof TrinketSlot) {
            TrinketSlot ts = (TrinketSlot)slot;
            assert (this.minecraft != null);
            ResourceLocation slotTextureId = ts.getBackgroundIdentifier();
            if (!slot.getItem().isEmpty() || slotTextureId == null) {
                slotTextureId = BLANK_BACK;
            }
            RenderSystem.enableDepthTest();
            if (ts.isTrinketFocused()) {
                context.blit(slotTextureId, slot.x, slot.y, 310, 0.0f, 0.0f, 16, 16, 16, 16);
                context.pose().translate(0.0f, 0.0f, 70.0f);
            } else {
                context.blit(slotTextureId, slot.x, slot.y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                context.blit(MORE_SLOTS, slot.x - 1, slot.y - 1, 0, 4.0f, 4.0f, 18, 18, 256, 256);
            }
        }
        if (TrinketsClient.activeGroup != null && TrinketsClient.activeGroup.getSlotId() == slot.index) {
            context.pose().translate(0.0f, 0.0f, 70.0f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isPointOverSlot"}, cancellable=true)
    private void isPointOverSlot(Slot slot, double pointX, double pointY, CallbackInfoReturnable<Boolean> info) {
        if (TrinketsClient.activeGroup != null) {
            if (slot instanceof TrinketSlot) {
                TrinketSlot ts = (TrinketSlot)slot;
                if (!ts.isTrinketFocused()) {
                    info.setReturnValue((Object)false);
                }
            } else if (slot instanceof CreativeModeInventoryScreen.SlotWrapper) {
                CreativeModeInventoryScreen.SlotWrapper cs = (CreativeModeInventoryScreen.SlotWrapper)slot;
                if (((CreativeSlotAccessor)cs).getSlot().index != TrinketsClient.activeGroup.getSlotId()) {
                    info.setReturnValue((Object)false);
                }
            } else if (slot.index != TrinketsClient.activeGroup.getSlotId()) {
                info.setReturnValue((Object)false);
            }
        }
    }
}

