/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.Point;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.api.SlotGroup;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu>
implements RecipeUpdateListener,
TrinketScreen {
    private InventoryScreenMixin() {
        super(null, null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"init"})
    private void init(CallbackInfo info) {
        TrinketScreenManager.init(this);
    }

    @Inject(at={@At(value="TAIL")}, method={"handledScreenTick"})
    private void tick(CallbackInfo info) {
        TrinketScreenManager.tick();
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        TrinketScreenManager.update(mouseX, mouseY);
    }

    @Inject(at={@At(value="RETURN")}, method={"drawBackground"})
    private void drawBackground(GuiGraphics context, float delta, int mouseX, int mouseY, CallbackInfo info) {
        TrinketScreenManager.drawExtraGroups(context);
    }

    @Inject(at={@At(value="TAIL")}, method={"drawForeground"})
    private void drawForeground(GuiGraphics context, int mouseX, int mouseY, CallbackInfo info) {
        TrinketScreenManager.drawActiveGroup(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"isClickOutsideBounds"}, cancellable=true)
    private void isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button, CallbackInfoReturnable<Boolean> info) {
        if (TrinketScreenManager.isClickInsideTrinketBounds(mouseX, mouseY)) {
            info.setReturnValue((Object)false);
        }
    }

    @Override
    public TrinketPlayerScreenHandler trinkets$getHandler() {
        return (TrinketPlayerScreenHandler)this.menu;
    }

    @Override
    public Rect2i trinkets$getGroupRect(SlotGroup group) {
        Point pos = ((TrinketPlayerScreenHandler)this.menu).trinkets$getGroupPos(group);
        if (pos != null) {
            return new Rect2i(pos.x() - 1, pos.y() - 1, 17, 17);
        }
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public Slot trinkets$getFocusedSlot() {
        return this.hoveredSlot;
    }

    @Override
    public int trinkets$getX() {
        return this.leftPos;
    }

    @Override
    public int trinkets$getY() {
        return this.topPos;
    }

    @Override
    public boolean trinkets$isRecipeBookOpen() {
        return this.getRecipeBookComponent().isVisible();
    }
}

