/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/common/util/AttributeTooltipContext;of(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/item/TooltipFlag;)Lnet/neoforged/neoforge/common/util/AttributeTooltipContext;")}, method={"getTooltip"})
    private void getTooltip(Item.TooltipContext context, Player player, TooltipFlag tooltipType, CallbackInfoReturnable<List<Component>> info, @Local(ordinal=0) List<Component> list) {
        TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(comp -> {
            ItemStack self = (ItemStack)this;
            boolean hideAdditionalTooltip = self.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
            boolean showAttributeTooltip = ((ItemAttributeModifiers)self.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).showInTooltip();
            if (hideAdditionalTooltip && !showAttributeTooltip) {
                return;
            }
            boolean canEquipAnywhere = true;
            HashSet slots = Sets.newHashSet();
            HashMap modifiers = Maps.newHashMap();
            Multimap<Holder<Attribute>, AttributeModifier> defaultModifier = null;
            boolean allModifiersSame = true;
            int slotCount = 0;
            for (Map.Entry<String, Map<String, TrinketInventory>> entry : comp.getInventory().entrySet()) {
                block1: for (Map.Entry<String, TrinketInventory> inventory : entry.getValue().entrySet()) {
                    TrinketInventory trinketInventory = inventory.getValue();
                    SlotType slotType = trinketInventory.getSlotType();
                    ++slotCount;
                    boolean anywhereButHidden = false;
                    for (int i = 0; i < trinketInventory.getContainerSize(); ++i) {
                        SlotReference ref = new SlotReference(trinketInventory, i);
                        boolean res = TrinketsApi.evaluatePredicateSet(slotType.getTooltipPredicates(), self, ref, (LivingEntity)player);
                        boolean canInsert = TrinketSlot.canInsert(self, ref, (LivingEntity)player);
                        if (res && canInsert) {
                            boolean sameTranslationExists = false;
                            for (SlotType t : slots) {
                                if (!t.getTranslation().getString().equals(slotType.getTranslation().getString())) continue;
                                sameTranslationExists = true;
                                break;
                            }
                            if (!sameTranslationExists) {
                                slots.add(slotType);
                            }
                            Multimap<Holder<Attribute>, AttributeModifier> map = TrinketModifiers.get(self, ref, (LivingEntity)player);
                            if (defaultModifier == null) {
                                defaultModifier = map;
                            } else if (allModifiersSame) {
                                allModifiersSame = this.areMapsEqual(defaultModifier, map);
                            }
                            boolean duplicate = false;
                            for (Map.Entry entry2 : modifiers.entrySet()) {
                                if (!((SlotType)entry2.getKey()).getTranslation().getString().equals(slotType.getTranslation().getString()) || !this.areMapsEqual((Multimap<Holder<Attribute>, AttributeModifier>)((Multimap)entry2.getValue()), map)) continue;
                                duplicate = true;
                                break;
                            }
                            if (duplicate) continue block1;
                            modifiers.put(slotType, map);
                            continue block1;
                        }
                        if (!canInsert) continue;
                        anywhereButHidden = true;
                    }
                    if (anywhereButHidden) continue;
                    canEquipAnywhere = false;
                }
            }
            if (!hideAdditionalTooltip) {
                if (canEquipAnywhere && slotCount > 1) {
                    list.add((Component)Component.translatable((String)"trinkets.tooltip.slots.any").withStyle(ChatFormatting.GRAY));
                } else if (slots.size() > 1) {
                    list.add((Component)Component.translatable((String)"trinkets.tooltip.slots.list").withStyle(ChatFormatting.GRAY));
                    for (SlotType slotType : slots) {
                        list.add((Component)slotType.getTranslation().withStyle(ChatFormatting.BLUE));
                    }
                } else if (slots.size() == 1) {
                    for (SlotType slotType : slots) {
                        list.add((Component)Component.translatable((String)"trinkets.tooltip.slots.single", (Object[])new Object[]{slotType.getTranslation().withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
                    }
                }
            }
            if (!modifiers.isEmpty() && showAttributeTooltip) {
                if (allModifiersSame) {
                    if (defaultModifier != null && !defaultModifier.isEmpty()) {
                        list.add((Component)Component.translatable((String)"trinkets.tooltip.attributes.all").withStyle(ChatFormatting.GRAY));
                        this.addAttributes(list, defaultModifier);
                    }
                } else {
                    for (Map.Entry<String, Map<String, TrinketInventory>> entry : modifiers.entrySet()) {
                        list.add((Component)Component.translatable((String)"trinkets.tooltip.attributes.single", (Object[])new Object[]{((SlotType)((Object)entry.getKey())).getTranslation().withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
                        this.addAttributes(list, (Multimap<Holder<Attribute>, AttributeModifier>)((Multimap)entry.getValue()));
                    }
                }
            }
        });
    }

    @Unique
    private void addAttributes(List<Component> list, Multimap<Holder<Attribute>, AttributeModifier> map) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entries()) {
                Holder attribute = (Holder)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double g = modifier.amount();
                if (modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                    if (((Holder)entry.getKey()).equals((Object)Attributes.KNOCKBACK_RESISTANCE)) {
                        g *= 10.0;
                    }
                } else {
                    g *= 100.0;
                }
                MutableComponent text = Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
                if (attribute.isBound() && attribute.value() instanceof SlotAttributes.SlotEntityAttribute) {
                    text = Component.translatable((String)"trinkets.tooltip.attributes.slots", (Object[])new Object[]{text});
                }
                if (g > 0.0) {
                    list.add((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(g), text}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(g < 0.0)) continue;
                list.add((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(g *= -1.0), text}).withStyle(ChatFormatting.RED));
            }
        }
    }

    @Unique
    private boolean areMapsEqual(Multimap<Holder<Attribute>, AttributeModifier> map1, Multimap<Holder<Attribute>, AttributeModifier> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Holder attribute : map1.keySet()) {
            if (!map2.containsKey((Object)attribute)) {
                return false;
            }
            Collection col1 = map1.get((Object)attribute);
            Collection col2 = map2.get((Object)attribute);
            if (col1.size() != col2.size()) {
                return false;
            }
            Iterator iter = col2.iterator();
            for (AttributeModifier modifier : col1) {
                AttributeModifier eam = (AttributeModifier)iter.next();
                if (!modifier.operation().equals((Object)eam.operation())) {
                    return false;
                }
                if (modifier.amount() == eam.amount()) continue;
                return false;
            }
        }
        return true;
    }
}

