/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private final Map<String, ItemStack> lastEquippedTrinkets = new HashMap<String, ItemStack>();

    @Shadow
    public abstract AttributeMap getAttributes();

    private LivingEntityMixin() {
        super(null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent((LivingEntity)this);
        if (component.isPresent()) {
            for (Tuple<SlotReference, ItemStack> equipped : component.get().getAllEquipped()) {
                if (!((ItemStack)equipped.getB()).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"dropInventory"})
    private void dropInventory(CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        boolean keepInv = entity.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.isEmpty()) {
                return;
            }
            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket(stack.getItem()).getDropRule((ItemStack)stack, (SlotReference)ref, entity);
            dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, (ItemStack)stack, (SlotReference)ref, entity);
            TrinketInventory inventory = ref.inventory();
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = inventory.getSlotType().getDropRule();
            }
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = keepInv && entity.getType() == EntityType.PLAYER ? TrinketEnums.DropRule.KEEP : (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP);
            }
            switch (dropRule) {
                case DROP: {
                    this.dropFromEntity((ItemStack)stack);
                }
                case DESTROY: {
                    inventory.setItem(ref.index(), ItemStack.EMPTY);
                    break;
                }
            }
        }));
    }

    @Unique
    private void dropFromEntity(ItemStack stack) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            livingEntityMixin = player.drop(stack, true, false);
        } else {
            livingEntityMixin = this.spawnAtLocation(stack);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.isRemoved()) {
            return;
        }
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> {
            HashMap newlyEquippedTrinkets = new HashMap();
            HashMap<String, ItemStack> contentUpdates = new HashMap<String, ItemStack>();
            trinkets.forEach((ref, stack) -> {
                TrinketInventory inventory = ref.inventory();
                SlotType slotType = inventory.getSlotType();
                int index = ref.index();
                ItemStack oldStack = this.getOldStack(slotType, index);
                ItemStack newStack = inventory.getItem(index);
                ItemStack newStackCopy = newStack.copy();
                String newRef = slotType.getGroup() + "/" + slotType.getName() + "/" + index;
                if (!ItemStack.matches((ItemStack)newStack, (ItemStack)oldStack)) {
                    TrinketsApi.getTrinket(oldStack.getItem()).onUnequip(oldStack, (SlotReference)ref, entity);
                    ((TrinketUnequipCallback)TrinketUnequipCallback.EVENT.invoker()).onUnequip(oldStack, (SlotReference)ref, entity);
                    TrinketsApi.getTrinket(newStack.getItem()).onEquip(newStack, (SlotReference)ref, entity);
                    ((TrinketEquipCallback)TrinketEquipCallback.EVENT.invoker()).onEquip(newStack, (SlotReference)ref, entity);
                    Level world = this.level();
                    if (!world.isClientSide) {
                        SlotAttributes.SlotEntityAttribute slotAttr;
                        Object patt0$temp;
                        HashSet toRemove;
                        HashMultimap slotMap;
                        Multimap<Holder<Attribute>, AttributeModifier> map;
                        contentUpdates.put(newRef, newStackCopy);
                        if (!oldStack.isEmpty()) {
                            map = TrinketModifiers.get(oldStack, ref, entity);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (Holder attr : map.keySet()) {
                                if (!attr.isBound() || !((patt0$temp = attr.value()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)((Object)((Object)((Object)((Object)patt0$temp))));
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(attr);
                            }
                            for (Holder attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            map.asMap().forEach((attribute, modifiers) -> {
                                AttributeInstance entityAttributeInstance = this.getAttributes().getInstance(attribute);
                                if (entityAttributeInstance != null) {
                                    modifiers.forEach(modifier -> entityAttributeInstance.removeModifier(modifier.id()));
                                }
                            });
                            trinkets.removeModifiers((Multimap<String, AttributeModifier>)slotMap);
                        }
                        if (!newStack.isEmpty()) {
                            map = TrinketModifiers.get(newStack, ref, entity);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (Holder attr : map.keySet()) {
                                if (!attr.isBound() || !((patt0$temp = attr.value()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)((Object)((Object)((Object)((Object)patt0$temp))));
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(attr);
                            }
                            for (Holder attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            map.forEach((attribute, attributeModifier) -> {
                                AttributeInstance entityAttributeInstance = this.getAttributes().getInstance(attribute);
                                if (entityAttributeInstance != null) {
                                    entityAttributeInstance.removeModifier(attributeModifier.id());
                                    entityAttributeInstance.addTransientModifier(attributeModifier);
                                }
                            });
                            trinkets.addTemporaryModifiers((Multimap<String, AttributeModifier>)slotMap);
                        }
                    }
                }
                TrinketsApi.getTrinket(newStack.getItem()).tick(newStack, (SlotReference)ref, entity);
                ItemStack tickedStack = inventory.getItem(index);
                if (tickedStack.getItem() == newStackCopy.getItem()) {
                    newlyEquippedTrinkets.put(newRef, tickedStack.copy());
                } else {
                    newlyEquippedTrinkets.put(newRef, newStackCopy);
                }
            });
            Level world = this.level();
            if (!world.isClientSide) {
                Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
                if (!contentUpdates.isEmpty() || !inventoriesToSend.isEmpty()) {
                    HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
                    for (TrinketInventory trinketInventory : inventoriesToSend) {
                        map.put(trinketInventory.getSlotType().getId(), trinketInventory.getSyncTag());
                    }
                    SyncInventoryPayload packet = new SyncInventoryPayload(this.getId(), contentUpdates, map);
                    for (ServerPlayer player : PlayerLookup.tracking((Entity)entity)) {
                        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)packet);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)packet);
                        if (!inventoriesToSend.isEmpty()) {
                            ((TrinketPlayerScreenHandler)serverPlayer.inventoryMenu).trinkets$updateTrinketSlots(false);
                        }
                    }
                    inventoriesToSend.clear();
                }
            }
            this.lastEquippedTrinkets.clear();
            this.lastEquippedTrinkets.putAll(newlyEquippedTrinkets);
        });
    }

    @Unique
    private ItemStack getOldStack(SlotType type, int index) {
        return this.lastEquippedTrinkets.getOrDefault(type.getGroup() + "/" + type.getName() + "/" + index, ItemStack.EMPTY);
    }
}

