/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerManagerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V")}, method={"onPlayerConnect"})
    private void onPlayerConnect(Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        EntitySlotLoader.SERVER.sync(player);
        ((TrinketPlayerScreenHandler)player.inventoryMenu).trinkets$updateTrinketSlots(false);
        TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(trinkets -> {
            HashMap<String, CompoundTag> tag = new HashMap<String, CompoundTag>();
            Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
            for (TrinketInventory trinketInventory : inventoriesToSend) {
                tag.put(trinketInventory.getSlotType().getId(), trinketInventory.getSyncTag());
            }
            ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new SyncInventoryPayload(player.getId(), Map.of(), tag));
            inventoriesToSend.clear();
        });
    }
}

