/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.NoSuchElementException;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EntityFeature
implements MarkdownFeature {
    public String name() {
        return "entities";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<entity;")) {
                return false;
            }
            String entityString = nibbler.consumeUntil('>');
            if (entityString == null) {
                return false;
            }
            try {
                class_2487 nbt = null;
                int nbtIndex = entityString.indexOf(123);
                if (nbtIndex != -1) {
                    nbt = new class_2522(new StringReader(entityString.substring(nbtIndex))).method_10727();
                    entityString = entityString.substring(0, nbtIndex);
                }
                class_1299 entityType = (class_1299)class_7923.field_41177.method_17966(class_2960.method_60654((String)entityString)).orElseThrow();
                tokens.add(new EntityToken(entityString, entityType, nbt));
                return true;
            }
            catch (CommandSyntaxException | NoSuchElementException e) {
                return false;
            }
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, entityToken, tokens) -> new EntityNode(entityToken.type, entityToken.nbt), (token, tokens) -> {
            EntityToken entity;
            return token instanceof EntityToken ? (entity = (EntityToken)((Object)token)) : null;
        });
    }

    private static class EntityToken
    extends Lexer.Token {
        public final class_1299<?> type;
        @Nullable
        public final class_2487 nbt;

        public EntityToken(String content, class_1299<?> type, @Nullable class_2487 nbt) {
            super(content);
            this.type = type;
            this.nbt = nbt;
        }
    }

    private static class EntityNode
    extends Parser.Node {
        public final class_1299<?> type;
        @Nullable
        public final class_2487 nbt;

        public EntityNode(class_1299<?> type, @Nullable class_2487 nbt) {
            this.type = type;
            this.nbt = nbt;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)Components.entity((Sizing)Sizing.fixed((int)32), this.type, (class_2487)this.nbt).scaleToFit(true));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

