/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Component;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2291;
import net.minecraft.class_7225;

public class ItemStackFeature
implements MarkdownFeature {
    private final class_7225.class_7874 registries;

    public ItemStackFeature(class_7225.class_7874 registries) {
        this.registries = registries;
    }

    public String name() {
        return "item_stacks";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<item;")) {
                return false;
            }
            String itemStackString = nibbler.consumeUntil('>');
            if (itemStackString == null) {
                return false;
            }
            try {
                class_2291.class_7215 result = new class_2291(this.registries).method_9789(new StringReader(itemStackString));
                class_1799 stack = ((class_1792)result.comp_628().comp_349()).method_7854();
                stack.method_57366(result.comp_2439());
                tokens.add(new ItemStackToken(itemStackString, stack));
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, stackToken, tokens) -> new ItemStackNode(stackToken.stack), (token, tokens) -> {
            ItemStackToken itemStack;
            return token instanceof ItemStackToken ? (itemStack = (ItemStackToken)((Object)token)) : null;
        });
    }

    private static class ItemStackToken
    extends Lexer.Token {
        public final class_1799 stack;

        public ItemStackToken(String content, class_1799 stack) {
            super(content);
            this.stack = stack;
        }
    }

    private static class ItemStackNode
    extends Parser.Node {
        private final class_1799 stack;

        public ItemStackNode(class_1799 stack) {
            this.stack = stack;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)Components.item((class_1799)this.stack).setTooltipFromStack(true));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

